/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.config;

import leaf.cosmere.common.config.ICosmereConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class AllomancyClientConfig
implements ICosmereConfig {
    private final ForgeConfigSpec configSpec;
    public final ForgeConfigSpec.BooleanValue drawMetalLines;
    public final ForgeConfigSpec.BooleanValue drawMetalBoxes;
    public final ForgeConfigSpec.BooleanValue canHearRain;

    AllomancyClientConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Client Config. This config only exists on the client").push("Allomancy");
        this.drawMetalLines = builder.comment("Iron/Steel vision draws metal lines between the user and the source of metal").define("drawMetalLines", true);
        this.drawMetalBoxes = builder.comment("Iron/Steel vision draws a blue box overlay over blocks that contain metal").define("drawMetalBoxes", true);
        this.canHearRain = builder.comment("Allomantic Tin picks up rain sounds, generating a sculk particle to player and showing an image at position of sound").define("canHearRain", true);
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "AllomancyClient";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.CLIENT;
    }

    public void clearCache() {
        this.drawMetalBoxes.clearCache();
        this.drawMetalLines.clearCache();
        this.canHearRain.clearCache();
    }
}

