/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.config;

import leaf.cosmere.common.config.ICosmereConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class AllomancyServerConfig
implements ICosmereConfig {
    private final ForgeConfigSpec configSpec;
    public final ForgeConfigSpec.DoubleValue IRON_STEEL_RANGE;
    public final ForgeConfigSpec.DoubleValue PUSH_PULL_WEIGHT;
    public final ForgeConfigSpec.DoubleValue MAX_PUSH_PULL_WEIGHT;

    AllomancyServerConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Allomancy Config. This config is synced between server and client.").push("allomancy");
        this.IRON_STEEL_RANGE = builder.comment("Multiplier for iron and steel range. At base strength (9) the range is 9 while burning and 18 while flaring").defineInRange("ironSteelRange", 1.0, 0.0, 10.0);
        this.PUSH_PULL_WEIGHT = builder.comment("Push/pull weight adjustment per block.").defineInRange("pushPullWeight", 0.05, 0.01, 100.0);
        this.MAX_PUSH_PULL_WEIGHT = builder.comment("Maximum pull/push weight adjustment. At 1.0 (default), push/pull power maxes out at 2 times (20 blocks)").defineInRange("maxPushPullWeight", 1.0, 0.0, 999999.0);
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "AllomancyServer";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public void clearCache() {
    }
}

