/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.items;

import java.util.function.Predicate;
import leaf.cosmere.allomancy.client.AllomancyKeybindings;
import leaf.cosmere.allomancy.common.Allomancy;
import leaf.cosmere.allomancy.common.coinpouch.CoinPouchContainerMenu;
import leaf.cosmere.allomancy.common.coinpouch.CoinPouchInventory;
import leaf.cosmere.allomancy.common.entities.CoinProjectile;
import leaf.cosmere.allomancy.common.manifestation.AllomancyIronSteel;
import leaf.cosmere.allomancy.common.network.packets.PlayerShootProjectileMessage;
import leaf.cosmere.allomancy.common.registries.AllomancyItems;
import leaf.cosmere.allomancy.common.registries.AllomancyManifestations;
import leaf.cosmere.api.CosmereTags;
import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.registration.impl.ItemRegistryObject;
import leaf.cosmere.common.registry.ItemsRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;

public class CoinPouchItem
extends ProjectileWeaponItem {
    public static final Predicate<ItemStack> SUPPORTED_PROJECTILES = itemStack -> {
        IHasMetalType metalType;
        boolean isNugget = itemStack.m_204117_(Tags.Items.NUGGETS) || itemStack.m_41720_() == ((ItemRegistryObject)ItemsRegistry.METAL_NUGGETS.get(Metals.MetalType.COPPER)).m_5456_();
        boolean containsMetal = itemStack.m_204117_(CosmereTags.Items.CONTAINS_METAL);
        Item item = itemStack.m_41720_();
        boolean isUncommonMetal = item instanceof IHasMetalType && (metalType = (IHasMetalType)item).getMetalType().getRarity() != Rarity.COMMON;
        return isNugget && containsMetal && !isUncommonMetal;
    };

    public CoinPouchItem(Item.Properties properties) {
        super(properties);
    }

    public Predicate<ItemStack> m_6437_() {
        return SUPPORTED_PROJECTILES;
    }

    public int m_6615_() {
        return 8;
    }

    public int m_8105_(ItemStack itemStack) {
        return 600;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack coinPouchStack = player.m_21120_(interactionHand);
        if (interactionHand == InteractionHand.MAIN_HAND && player.m_6047_()) {
            if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                SimpleMenuProvider container = new SimpleMenuProvider((windowID, playerInv, plyr) -> new CoinPouchContainerMenu(windowID, playerInv, coinPouchStack), (Component)Component.m_237115_((String)"item.allomancy.coin_pouch"));
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)container, buf -> buf.writeBoolean(true));
            }
        } else if (player.m_9236_().f_46443_ && AllomancyKeybindings.ALLOMANCY_STEEL_PUSH.m_90857_()) {
            Allomancy.packetHandler().sendToServer(new PlayerShootProjectileMessage());
        }
        return InteractionResultHolder.m_19096_((Object)coinPouchStack);
    }

    public void shoot(Player player, ItemStack coinPouchStack) {
        SpiritwebCapability.get((LivingEntity)player).ifPresent(data -> {
            AllomancyIronSteel steelManifestation = (AllomancyIronSteel)((Object)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.STEEL).get()));
            if (steelManifestation.isActive((ISpiritweb)data) && steelManifestation.getMode((ISpiritweb)data) > 0) {
                boolean playerCreativeMode = player.m_150110_().f_35937_;
                boolean infiniteAmmo = playerCreativeMode || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)coinPouchStack) > 0;
                ItemStack ammo = this.getProjectile(player, coinPouchStack);
                if (!ammo.m_41619_() || infiniteAmmo) {
                    ItemStack stackToShoot = ammo.m_41777_().m_41620_(1);
                    if (!infiniteAmmo) {
                        ammo.m_41774_(1);
                    }
                    if (!player.m_9236_().f_46443_) {
                        CoinProjectile coinProjectile = new CoinProjectile(player.m_9236_(), (LivingEntity)player, stackToShoot);
                        coinProjectile.m_36762_(true);
                        coinProjectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                        coinProjectile.f_36705_ = infiniteAmmo ? AbstractArrow.Pickup.DISALLOWED : AbstractArrow.Pickup.ALLOWED;
                        player.m_9236_().m_7967_((Entity)coinProjectile);
                        steelManifestation.trackValidEntity((ISpiritweb)data, (Entity)coinProjectile);
                    }
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (player.m_9236_().m_213780_().m_188501_() * 0.4f + 1.2f) + 0.5f);
                }
            }
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag oldCapNbt) {
        CoinPouchInventory coinPouchInventory = new CoinPouchInventory();
        if (oldCapNbt != null) {
            coinPouchInventory.deserializeNBT(oldCapNbt);
        }
        return coinPouchInventory;
    }

    public ItemStack getProjectile(Player player, ItemStack coinPouchStack) {
        if (!(coinPouchStack.m_41720_() instanceof ProjectileWeaponItem)) {
            return ItemStack.f_41583_;
        }
        IItemHandlerModifiable bagInv = CoinPouchItem.getBagInv(coinPouchStack);
        Predicate predicate = ((ProjectileWeaponItem)coinPouchStack.m_41720_()).m_6442_();
        for (int i = 0; i < bagInv.getSlots(); ++i) {
            ItemStack stackInSlot = bagInv.getStackInSlot(i);
            if (!predicate.test(stackInSlot)) continue;
            return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)coinPouchStack, (ItemStack)stackInSlot);
        }
        return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)coinPouchStack, (ItemStack)(player.m_150110_().f_35937_ ? new ItemStack((ItemLike)ItemsRegistry.METAL_NUGGETS.get(Metals.MetalType.COPPER)) : ItemStack.f_41583_));
    }

    private static IItemHandlerModifiable getBagInv(ItemStack coinPouchStack) {
        return (IItemHandlerModifiable)coinPouchStack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
    }

    public static boolean onPickupItem(Entity entity, Player player) {
        boolean isCoinProjectile;
        ItemEntity itemEntity = entity instanceof ItemEntity ? (ItemEntity)entity : null;
        CoinProjectile coinProjectile = entity instanceof CoinProjectile ? (CoinProjectile)entity : null;
        boolean isItemEntity = itemEntity != null;
        boolean bl = isCoinProjectile = coinProjectile != null;
        if (!isItemEntity && !isCoinProjectile) {
            return false;
        }
        ItemStack entityStack = isItemEntity ? itemEntity.m_32055_() : coinProjectile.m_7846_();
        int originalCount = entityStack.m_41613_();
        if (SUPPORTED_PROJECTILES.test(entityStack)) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                int amountTaken;
                ItemStack bag = player.m_150109_().m_8020_(i);
                if (bag.m_41619_() || !bag.m_150930_((Item)AllomancyItems.COIN_POUCH.get())) continue;
                IItemHandlerModifiable bagInv = CoinPouchItem.getBagInv(bag);
                for (int j = 0; j < bagInv.getSlots() && !(entityStack = bagInv.insertItem(j, entityStack, false)).m_41619_(); ++j) {
                }
                if (player.m_150109_().m_36040_(-1, entityStack)) {
                    // empty if block
                }
                if ((amountTaken = originalCount - entityStack.m_41613_()) <= 0) continue;
                if (isItemEntity) {
                    itemEntity.m_32045_(entityStack);
                    player.m_7938_((Entity)itemEntity, amountTaken);
                } else {
                    coinProjectile.m_146870_();
                }
                return true;
            }
        }
        return false;
    }
}

