/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.items;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import leaf.cosmere.allomancy.common.registries.AllomancyItems;
import leaf.cosmere.allomancy.common.utils.MiscHelper;
import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.CompoundNBTHelper;
import leaf.cosmere.api.helpers.PlayerHelper;
import leaf.cosmere.api.text.TextHelper;
import leaf.cosmere.common.items.BaseItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MetalVialItem
extends BaseItem
implements IHasMetalType {
    private static final String metal_ids = "metalIDs";
    private static final String metal_amounts = "metalAmounts";
    private static final int MAX_METALS_COUNT = 16;

    public void addFilled(CreativeModeTab.Output output) {
        ItemStack filled = new ItemStack((ItemLike)this);
        for (int i = 0; i < 16; ++i) {
            MetalVialItem.addMetals(filled, i, 1);
        }
        output.m_246342_(filled);
    }

    private static CompoundTag getContainedMetalsTag(ItemStack stack) {
        return stack.m_41698_("metals_contained");
    }

    public static boolean isFull(ItemStack stack) {
        return MetalVialItem.containedMetalCount(stack) >= MetalVialItem.getMaxFillCount(stack);
    }

    public static int getMaxFillCount(ItemStack stack) {
        CompoundTag stackTags = stack.m_41784_();
        String max_count = "max_count";
        return stackTags.m_128441_("max_count") ? stackTags.m_128451_("max_count") : 16;
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 16;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36391_(true) && MetalVialItem.containedMetalCount(player.m_21120_(hand)) > 0) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (worldIn.f_46443_) {
            return stack;
        }
        Player playerentity = entityLiving instanceof Player ? (Player)entityLiving : null;
        Map<Integer, Integer> metalsInVial = MetalVialItem.getStoredMetalsMap(MetalVialItem.getContainedMetalsTag(stack));
        metalsInVial.entrySet().forEach(metalInfo -> MiscHelper.consumeNugget(entityLiving, stack));
        if (playerentity == null || !playerentity.m_150110_().f_35937_) {
            if (stack.m_41619_()) {
                return new ItemStack((ItemLike)AllomancyItems.METAL_VIAL.get());
            }
            if (playerentity != null) {
                if (stack.m_41613_() > 1) {
                    ItemStack splitStack = stack.m_41620_(1);
                    this.emptyMetals(splitStack);
                    PlayerHelper.addItem((Player)playerentity, (ItemStack)splitStack);
                } else {
                    this.emptyMetals(stack);
                }
            }
        }
        return stack;
    }

    public static int containedMetalCount(ItemStack stack) {
        int[] metalAmounts;
        int count = 0;
        for (int metalCount : metalAmounts = CompoundNBTHelper.getIntArray((CompoundTag)MetalVialItem.getContainedMetalsTag(stack), (String)metal_amounts)) {
            count += metalCount;
        }
        return count;
    }

    public static void addMetals(ItemStack stack, int metalID, int count) {
        if (!(stack.m_41720_() instanceof MetalVialItem)) {
            return;
        }
        CompoundTag nbt = MetalVialItem.getContainedMetalsTag(stack);
        Map<Integer, Integer> sorted = MetalVialItem.getStoredMetalsMap(nbt);
        if (sorted.containsKey(metalID)) {
            count += sorted.get(metalID).intValue();
        }
        sorted.put(metalID, count);
        ArrayList<Integer> keys = new ArrayList<Integer>(sorted.keySet());
        ArrayList<Integer> values = new ArrayList<Integer>(sorted.values());
        CompoundNBTHelper.setIntArray((CompoundTag)nbt, (String)metal_ids, keys);
        CompoundNBTHelper.setIntArray((CompoundTag)nbt, (String)metal_amounts, values);
    }

    private static Map<Integer, Integer> getStoredMetalsMap(CompoundTag nbt) {
        int[] metalIDs = CompoundNBTHelper.getIntArray((CompoundTag)nbt, (String)metal_ids);
        int[] metalAmounts = CompoundNBTHelper.getIntArray((CompoundTag)nbt, (String)metal_amounts);
        Map sorted = IntStream.range(0, metalIDs.length).boxed().collect(Collectors.toMap(i -> metalIDs[i], i -> metalAmounts[i], (i, j) -> i, LinkedHashMap::new));
        return sorted;
    }

    public void emptyMetals(ItemStack stack) {
        CompoundTag nbt = MetalVialItem.getContainedMetalsTag(stack);
        nbt.m_128473_(metal_ids);
        nbt.m_128473_(metal_amounts);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return this.getBarWidth(MetalVialItem.containedMetalCount(stack), 16.0f);
    }

    public int m_142159_(ItemStack stack) {
        return this.getBarColour(MetalVialItem.containedMetalCount(stack), 16.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Map<Integer, Integer> sorted = MetalVialItem.getStoredMetalsMap(MetalVialItem.getContainedMetalsTag(stack));
        tooltip.add((Component)TextHelper.createTranslatedText((String)"tooltip.cosmere.metals.contained", (Object[])new Object[0]));
        sorted.entrySet().stream().forEach(metalInfo -> {
            String metalName = ((Metals.MetalType)Metals.MetalType.valueOf((int)((Integer)metalInfo.getKey())).get()).m_6082_();
            String metalTranslation = String.format("item.cosmere.%s_nugget", metalName);
            tooltip.add((Component)TextHelper.createTranslatedText((String)metalTranslation, (Object[])new Object[0]).m_7220_((Component)TextHelper.createText((Object)String.format(": x%s", metalInfo.getValue()))));
        });
        tooltip.add((Component)TextHelper.createText((Object)String.format("%s / %s", MetalVialItem.containedMetalCount(stack), 16)));
    }

    public Metals.MetalType getMetalType() {
        return Metals.MetalType.IRON;
    }

    public static void addMetals(ItemStack newMetalVialStack, ItemStack oldMetalVialStack) {
        Map<Integer, Integer> sorted = MetalVialItem.getStoredMetalsMap(MetalVialItem.getContainedMetalsTag(oldMetalVialStack));
        for (Integer metalID : sorted.keySet()) {
            MetalVialItem.addMetals(newMetalVialStack, metalID, sorted.get(metalID));
        }
    }
}

