/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.manifestation;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import leaf.cosmere.allomancy.common.manifestation.AllomancyEntityThread;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.EffectsHelper;
import leaf.cosmere.api.helpers.EntityHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class AllomancyBendalloy
extends AllomancyManifestation {
    private static final HashMap<String, BendalloyThread> playerThreadMap = new HashMap();

    public AllomancyBendalloy(Metals.MetalType metalType) {
        super(metalType);
    }

    protected void applyEffectTick(ISpiritweb data) {
        if (AllomancyEntityThread.serverShutdown) {
            return;
        }
        int mode = this.getMode(data);
        String uuid = data.getLiving().m_20149_();
        if (data.getLiving().m_9236_().m_7654_().m_6846_().m_11259_(data.getLiving().m_20148_()) == null) {
            return;
        }
        if (playerThreadMap.get(uuid) == null) {
            playerThreadMap.put(uuid, new BendalloyThread(data));
        }
        List<LivingEntity> entitiesToAffect = playerThreadMap.get(uuid).requestEntityList();
        for (LivingEntity e : entitiesToAffect) {
            e.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19597_, (int)mode));
        }
    }

    @Override
    public void onModeChange(ISpiritweb data, int lastMode) {
        String uuid = data.getLiving().m_20149_();
        if (this.getMode(data) <= 0) {
            playerThreadMap.remove(uuid);
        }
        super.onModeChange(data, lastMode);
    }

    @Override
    public boolean tick(ISpiritweb data) {
        String uuid = data.getLiving().m_20149_();
        if (!playerThreadMap.containsKey(uuid)) {
            playerThreadMap.put(uuid, new BendalloyThread(data));
        }
        playerThreadMap.entrySet().removeIf(entry -> !((BendalloyThread)entry.getValue()).isRunning || AllomancyEntityThread.serverShutdown || entry.getValue() == null);
        return super.tick(data);
    }

    class BendalloyThread
    extends AllomancyEntityThread {
        public BendalloyThread(ISpiritweb data) {
            super(data);
            Thread t = new Thread((Runnable)this, "bendalloy_thread_" + data.getLiving().m_5446_().getString());
            t.start();
        }

        @Override
        public void run() {
            while (true) {
                int mode = AllomancyBendalloy.this.getMode(this.data);
                if (serverShutdown || mode <= 0) break;
                try {
                    if (lock.tryLock()) {
                        int range = AllomancyBendalloy.this.getRange(this.data);
                        List newEntityList = EntityHelper.getLivingEntitiesInRange((LivingEntity)this.data.getLiving(), (int)range, (boolean)false);
                        this.setEntityList(newEntityList);
                        lock.unlock();
                    }
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    CosmereAPI.logger.debug(Arrays.toString(e.getStackTrace()));
                    if (!(e instanceof ConcurrentModificationException)) break;
                    lock.unlock();
                    break;
                }
            }
            this.isRunning = false;
        }
    }
}

