/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.manifestation;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import leaf.cosmere.allomancy.common.manifestation.AllomancyEntityThread;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.EntityHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AllomancyCadmium
extends AllomancyManifestation {
    private static final HashMap<String, CadmiumThread> playerThreadMap = new HashMap();

    public AllomancyCadmium(Metals.MetalType metalType) {
        super(metalType);
    }

    protected void applyEffectTick(ISpiritweb data) {
        int mode = this.getMode(data);
        String uuid = data.getLiving().m_20149_();
        if (data.getLiving().m_9236_().m_7654_().m_6846_().m_11259_(data.getLiving().m_20148_()) == null) {
            return;
        }
        if (playerThreadMap.get(uuid) == null) {
            playerThreadMap.put(uuid, new CadmiumThread(data));
        }
        int range = this.getRange(data);
        int x = (int)(data.getLiving().m_20185_() + (data.getLiving().m_20208_((double)(range * 2 + 1)) - (double)range));
        int z = (int)(data.getLiving().m_20189_() + (data.getLiving().m_20262_((double)(range * 2 + 1)) - (double)range));
        for (int i = 4; i > -2; --i) {
            int y = data.getLiving().m_20183_().m_123342_() + i;
            BlockPos pos = new BlockPos(x, y, z);
            Level world = data.getLiving().m_9236_();
            if (world.m_46859_(pos)) continue;
            BlockState state = world.m_8055_(pos);
            state.m_222972_((ServerLevel)world, pos, world.f_46441_);
            break;
        }
        List<LivingEntity> entitiesToCheck = playerThreadMap.get(uuid).requestEntityList();
        for (LivingEntity e : entitiesToCheck) {
            try {
                e.m_8107_();
            }
            catch (Exception err) {
                if (err instanceof NullPointerException) continue;
                err.printStackTrace();
            }
        }
        playerThreadMap.get(uuid).releaseEntityList();
    }

    @Override
    public void onModeChange(ISpiritweb data, int lastMode) {
        String uuid = data.getLiving().m_20149_();
        if (this.getMode(data) <= 0) {
            playerThreadMap.remove(uuid);
        }
        super.onModeChange(data, lastMode);
    }

    @Override
    public boolean tick(ISpiritweb data) {
        String uuid = data.getLiving().m_20149_();
        if (!playerThreadMap.containsKey(uuid)) {
            playerThreadMap.put(uuid, new CadmiumThread(data));
        }
        playerThreadMap.entrySet().removeIf(entry -> !((CadmiumThread)entry.getValue()).isRunning || AllomancyEntityThread.serverShutdown || entry.getValue() == null);
        return super.tick(data);
    }

    class CadmiumThread
    extends AllomancyEntityThread {
        public CadmiumThread(ISpiritweb data) {
            super(data);
            Thread t = new Thread((Runnable)this, "cadmium_thread_" + data.getLiving().m_5446_());
            t.start();
        }

        @Override
        public void run() {
            while (!serverShutdown) {
                try {
                    int mode = AllomancyCadmium.this.getMode(this.data);
                    if (mode <= 0 || this.data.getLiving().m_9236_().m_7654_().m_6846_().m_11259_(this.data.getLiving().m_20148_()) == null) break;
                    if (lock.tryLock()) {
                        int range = AllomancyCadmium.this.getRange(this.data);
                        List newEntityList = EntityHelper.getLivingEntitiesInRange((LivingEntity)this.data.getLiving(), (int)range, (boolean)true);
                        this.setEntityList(newEntityList);
                        lock.unlock();
                    }
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    CosmereAPI.logger.debug(Arrays.toString(e.getStackTrace()));
                    if (!(e instanceof ConcurrentModificationException)) break;
                    lock.unlock();
                    break;
                }
            }
            this.isRunning = false;
        }
    }
}

