/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.manifestation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import leaf.cosmere.allomancy.common.config.AllomancyConfigs;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.allomancy.common.registries.AllomancyManifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.EffectsHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;

public class AllomancyTin
extends AllomancyManifestation {
    private static final HashMap<Vec3, Integer> soundPosMap = new HashMap();

    public AllomancyTin(Metals.MetalType metalType) {
        super(metalType);
    }

    public static ArrayList<Vec3> getTinSoundList() {
        return new ArrayList<Vec3>(soundPosMap.keySet());
    }

    @Override
    public void onModeChange(ISpiritweb data, int lastMode) {
        int mode;
        super.onModeChange(data, lastMode);
        if (data.getLiving().m_9236_().m_5776_() && (mode = this.getMode(data)) <= 0) {
            soundPosMap.clear();
        }
    }

    public void applyEffectTick(ISpiritweb data) {
        int blockLighting;
        LivingEntity living = data.getLiving();
        if (living.m_21023_(MobEffects.f_216964_)) {
            living.m_21195_(MobEffects.f_216964_);
        }
        if ((blockLighting = living.m_146900_().m_60791_()) > 14) {
            living.m_7292_(EffectsHelper.getNewEffect((MobEffect)MobEffects.f_19610_, (int)(blockLighting - 14)));
        } else if (blockLighting < 8 && living.m_21023_(MobEffects.f_19610_)) {
            living.m_21195_(MobEffects.f_19610_);
        }
        if (living.m_9236_().m_5776_() && living instanceof LocalPlayer) {
            soundPosMap.entrySet().removeIf(entry -> (Integer)entry.getValue() <= 0);
            Vec3 playerPos = new Vec3(living.m_20182_().f_82479_, living.m_20182_().f_82480_, living.m_20182_().f_82481_);
            Vec3 lookAngle = living.m_20154_();
            playerPos = playerPos.m_82520_(lookAngle.f_82479_, 1.2, lookAngle.f_82481_);
            AbsolutePositionSource playerSource = new AbsolutePositionSource(playerPos);
            for (Vec3 v : soundPosMap.keySet()) {
                if (soundPosMap.get(v) > 18) {
                    VibrationParticleOption vib = new VibrationParticleOption((PositionSource)playerSource, 10);
                    living.m_9236_().m_7106_((ParticleOptions)vib, v.f_82479_, v.f_82480_, v.f_82481_, 1.0, 1.0, 1.0);
                }
                soundPosMap.put(v, soundPosMap.get(v) - 1);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onSound(PlaySoundEvent event) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        SoundInstance eventSound = event.getSound();
        AllomancyTin tinAllomancy = (AllomancyTin)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.TIN).get());
        if (eventSound == null) {
            return;
        }
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        SpiritwebCapability.get((LivingEntity)localPlayer).ifPresent(arg_0 -> AllomancyTin.lambda$onSound$1(event, tinAllomancy, (Player)localPlayer, arg_0));
    }

    private static /* synthetic */ void lambda$onSound$1(PlaySoundEvent event, AllomancyTin tinAllomancy, Player localPlayer, ISpiritweb playerSpiritweb) {
        if (event.getName().equals("weather.rain") && !((Boolean)AllomancyConfigs.CLIENT.canHearRain.get()).booleanValue()) {
            return;
        }
        boolean isBronzeSound = event.getName().equals("block.note_block.basedrum");
        if (tinAllomancy.isActive(playerSpiritweb) && !isBronzeSound) {
            int range;
            Vec3 soundPos = new Vec3(event.getSound().m_7772_(), event.getSound().m_7780_(), event.getSound().m_7778_());
            double distance = localPlayer.m_20182_().m_82554_(soundPos);
            if (distance < (double)(range = tinAllomancy.getRange(playerSpiritweb))) {
                soundPosMap.put(soundPos, 20);
            }
        }
    }

    static class AbsolutePositionSource
    implements PositionSource {
        private Vec3 pos;

        public AbsolutePositionSource(Vec3 pos) {
            this.pos = pos;
        }

        public Optional<Vec3> m_142502_(Level pLevel) {
            return Optional.of(this.pos);
        }

        public PositionSourceType<?> m_142510_() {
            return PositionSourceType.f_157872_;
        }
    }
}

