/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.spittingimage;

import com.mojang.logging.LogUtils;
import mett.palemannie.spittingimage.KeyBindings;
import mett.palemannie.spittingimage.entity.ModEntities;
import mett.palemannie.spittingimage.item.ModItems;
import mett.palemannie.spittingimage.network.ModMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="spittingimage")
public class SpittingImage {
    public static final String MODID = "spittingimage";
    private static final Logger LOGGER = LogUtils.getLogger();

    public SpittingImage(IEventBus modEventBus, Dist dist, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        ModItems.register(modEventBus);
        ModEntities.register(modEventBus);
        modEventBus.addListener(ModMessages::registerMessages);
        if (dist == Dist.CLIENT) {
            modEventBus.addListener(KeyBindings::registerBindings);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @EventBusSubscriber(modid="spittingimage", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
            KeyBindings.register();
            EntityRenderers.register(ModEntities.SPIT_PROJECTILE.get(), ThrownItemRenderer::new);
        }
    }
}

