/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.spittingimage.entity;

import mett.palemannie.spittingimage.item.ModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class SpitEntity
extends ThrowableItemProjectile {
    public SpitEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        if (this.isInWaterOrBubble()) {
            this.discard();
        } else if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBehaviour.BlockStateBase::isAir)) {
            this.discard();
        }
        if (this.tickCount % 7 == 0) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SPIT, this.getX(), this.getY() + 0.2, this.getZ(), 0.0, 0.0, 0.0);
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX(), this.getY() + 0.2, this.getZ(), 0.0, 0.0, 0.0);
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
        super.onHitBlock(result);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 1.0f);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.SPIT.get();
    }
}

