/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.spittingimage.network;

import mett.palemannie.spittingimage.entity.ModEntities;
import mett.palemannie.spittingimage.entity.SpitEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ServerPlayHandler {
    public static void handleSpitting(ServerPlayer player) {
        Level world = player.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            SpitEntity spitEntity = new SpitEntity(ModEntities.SPIT_PROJECTILE.get(), (Level)serverWorld);
            spitEntity.setOwner((Entity)player);
            spitEntity.setPosRaw(player.getX(), player.getEyeY() - (double)0.15f, player.getZ());
            float velocity = 0.45f + world.random.nextFloat() * 0.1f;
            spitEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, velocity, 1.0f);
            serverWorld.addFreshEntity((Entity)spitEntity);
        }
        Level lvl = player.level();
        float r = 0.8f + lvl.random.nextFloat() * 0.3f;
        lvl.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.LLAMA_SPIT, SoundSource.BLOCKS, 1.0f, r);
        Vec3 vec3 = player.getViewVector(1.0f);
        Vec3 MousePos = player.getEyePosition();
        double x = player.getX() + vec3.x / 4.0;
        double y = MousePos.y + vec3.y / 4.0;
        double z = player.getZ() + vec3.z / 4.0;
        if (lvl instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)lvl;
            slevel.sendParticles((ParticleOptions)ParticleTypes.SPIT, x, y, z, 3, 0.0, 0.0, 0.0, 0.15);
        }
    }
}

