/*
 * Decompiled with CFR 0.152.
 */
package ca.diggsly.fabric.handler;

import ca.diggsly.fabric.data.CropSpawnConfig;
import ca.diggsly.fabric.data.CropSpawnLoader;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CropHarvestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CropHarvestHandler.class);
    private static final Random RANDOM = new Random();
    private static final ThreadLocal<Set<class_2338>> PROCESSING_POSITIONS = ThreadLocal.withInitial(HashSet::new);

    public static void register() {
        PlayerBlockBreakEvents.BEFORE.register(CropHarvestHandler::onBlockBreakBefore);
        LOGGER.info("Registered Grow-A-Mon crop harvest handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean onBlockBreakBefore(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (!(world instanceof class_3218)) {
            return true;
        }
        class_3218 serverLevel = (class_3218)world;
        Set<class_2338> processing = PROCESSING_POSITIONS.get();
        if (processing.contains(pos)) {
            processing.remove(pos);
            return false;
        }
        class_2338 mainPos = pos;
        class_2680 mainState = state;
        class_2338 otherHalfPos = null;
        class_2338 abovePos = pos.method_10084();
        class_2680 aboveState = world.method_8320(abovePos);
        if (aboveState.method_26204() == state.method_26204() && !aboveState.equals(state)) {
            otherHalfPos = abovePos;
            mainPos = pos;
        } else {
            class_2338 belowPos = pos.method_10074();
            class_2680 belowState = world.method_8320(belowPos);
            if (belowState.method_26204() == state.method_26204() && !belowState.equals(state)) {
                mainPos = belowPos;
                mainState = belowState;
                otherHalfPos = pos;
            }
        }
        if (!mainPos.equals((Object)pos)) {
            return true;
        }
        if (otherHalfPos != null) {
            processing.add(otherHalfPos);
        }
        processing.add(mainPos);
        try {
            boolean cancelDrops = false;
            boolean processedAny = false;
            boolean hasSpawned = false;
            List<CropSpawnConfig> configs = CropSpawnLoader.getConfigs();
            for (CropSpawnConfig config : configs) {
                if (!config.matches(mainState)) continue;
                boolean result = true;
                if (hasSpawned) continue;
                result = CropHarvestHandler.handleBlockBreak(serverLevel, mainPos, mainState, player, config);
                processedAny = true;
                if (result) continue;
                hasSpawned = true;
                cancelDrops = true;
            }
            if (processedAny) {
                boolean bl = !cancelDrops;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            processing.remove(mainPos);
            if (otherHalfPos != null) {
                processing.remove(otherHalfPos);
            }
        }
    }

    private static boolean handleBlockBreak(class_3218 world, class_2338 pos, class_2680 state, class_1657 player, CropSpawnConfig config) {
        if (RANDOM.nextDouble() < config.getOdds()) {
            boolean spawnSucceeded = CropHarvestHandler.spawnCobblemon(world, pos, config, player);
            if (config.shouldCancelDrops() && spawnSucceeded) {
                CropHarvestHandler.destroyBlockWithConnected(world, pos, state);
                return false;
            }
            return true;
        }
        return true;
    }

    private static boolean spawnCobblemon(class_3218 world, class_2338 pos, CropSpawnConfig config, class_1657 player) {
        try {
            String cobblemonId = config.getCobblemonId();
            class_2960 speciesId = class_2960.method_12829((String)cobblemonId);
            if (speciesId == null) {
                LOGGER.error("Invalid Cobblemon ID: {}", (Object)cobblemonId);
                return false;
            }
            Species species = PokemonSpecies.INSTANCE.getByIdentifier(speciesId);
            if (species == null) {
                LOGGER.error("Unknown Cobblemon species: {}", (Object)cobblemonId);
                return false;
            }
            int level = config.getMinLevel();
            if (config.getMaxLevel() > config.getMinLevel()) {
                level = config.getMinLevel() + RANDOM.nextInt(config.getMaxLevel() - config.getMinLevel() + 1);
            }
            Pokemon pokemon = species.create(level);
            if (config.getShinyOdds() > 0.0 && RANDOM.nextDouble() < config.getShinyOdds()) {
                pokemon.setShiny(true);
                LOGGER.info("Spawned shiny {} from crop harvest!", (Object)species.getName());
            }
            for (String aspect : config.getAspects()) {
                pokemon.getAspects().add(aspect);
            }
            if (!config.getIvs().isEmpty()) {
                if (config.getIvs().containsKey("hp")) {
                    int ivValue = CropHarvestHandler.generateIvInRange("hp", config);
                    pokemon.getIvs().set((Stat)Stats.HP, ivValue);
                }
                if (config.getIvs().containsKey("attack")) {
                    int ivValue = CropHarvestHandler.generateIvInRange("attack", config);
                    pokemon.getIvs().set((Stat)Stats.ATTACK, ivValue);
                }
                if (config.getIvs().containsKey("defense")) {
                    int ivValue = CropHarvestHandler.generateIvInRange("defense", config);
                    pokemon.getIvs().set((Stat)Stats.DEFENCE, ivValue);
                }
                if (config.getIvs().containsKey("special_attack")) {
                    int ivValue = CropHarvestHandler.generateIvInRange("special_attack", config);
                    pokemon.getIvs().set((Stat)Stats.SPECIAL_ATTACK, ivValue);
                }
                if (config.getIvs().containsKey("special_defense")) {
                    int ivValue = CropHarvestHandler.generateIvInRange("special_defense", config);
                    pokemon.getIvs().set((Stat)Stats.SPECIAL_DEFENCE, ivValue);
                }
                if (config.getIvs().containsKey("speed")) {
                    int ivValue = CropHarvestHandler.generateIvInRange("speed", config);
                    pokemon.getIvs().set((Stat)Stats.SPEED, ivValue);
                }
            }
            double x = (double)pos.method_10263() + 0.5;
            double y = pos.method_10264();
            double z = (double)pos.method_10260() + 0.5;
            pokemon.sendOut(world, new class_243(x, y, z), null, entity -> null);
            LOGGER.info("Spawned {} at {}, {}, {} from crop harvest by {}", new Object[]{species.getName(), x, y, z, player.method_5477().getString()});
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to spawn Cobblemon: {}", (Object)config.getCobblemonId(), (Object)e);
            return false;
        }
    }

    private static void destroyBlockWithConnected(class_3218 world, class_2338 pos, class_2680 state) {
        class_2338 otherHalfPos = null;
        class_2338 abovePos = pos.method_10084();
        class_2680 aboveState = world.method_8320(abovePos);
        if (aboveState.method_26204() == state.method_26204() && !aboveState.equals(state)) {
            otherHalfPos = abovePos;
        } else {
            class_2338 belowPos = pos.method_10074();
            class_2680 belowState = world.method_8320(belowPos);
            if (belowState.method_26204() == state.method_26204() && !belowState.equals(state)) {
                otherHalfPos = belowPos;
            }
        }
        world.method_8650(pos, false);
        if (otherHalfPos != null) {
            world.method_8650(otherHalfPos, false);
        }
    }

    private static int generateIvInRange(String stat, CropSpawnConfig config) {
        int max;
        int min = config.getIvs().get(stat);
        if (min == (max = config.getIvsMax().get(stat).intValue())) {
            return min;
        }
        return min + RANDOM.nextInt(max - min + 1);
    }
}

