/*
 * Decompiled with CFR 0.152.
 */
package ca.diggsly.fabric.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class CropSpawnConfig {
    private final String blockId;
    private final String cobblemonId;
    private final double odds;
    private final Integer requiredAge;
    private final int minLevel;
    private final int maxLevel;
    private final double shinyOdds;
    private final List<String> aspects;
    private final Map<String, Integer> ivs;
    private final Map<String, Integer> ivsMax;
    private final boolean cancelDrops;

    public CropSpawnConfig(String blockId, String cobblemonId, double odds, Integer requiredAge, int minLevel, int maxLevel, double shinyOdds, List<String> aspects, Map<String, Integer> ivs, Map<String, Integer> ivsMax, boolean cancelDrops) {
        this.blockId = blockId;
        this.cobblemonId = cobblemonId;
        this.odds = Math.max(0.0, Math.min(1.0, odds));
        this.requiredAge = requiredAge;
        this.minLevel = Math.max(1, Math.min(minLevel, maxLevel));
        this.maxLevel = Math.max(minLevel, maxLevel);
        this.shinyOdds = Math.max(0.0, Math.min(1.0, shinyOdds));
        this.aspects = aspects != null ? new ArrayList<String>(aspects) : new ArrayList();
        this.ivs = ivs != null ? new HashMap<String, Integer>(ivs) : new HashMap();
        this.ivsMax = ivsMax != null ? new HashMap<String, Integer>(ivsMax) : new HashMap();
        this.cancelDrops = cancelDrops;
    }

    public static CropSpawnConfig fromJson(JsonObject json) {
        String blockId = json.get("block").getAsString();
        String cobblemonId = json.get("cobblemon").getAsString();
        double odds = json.get("odds").getAsDouble();
        Integer requiredAge = null;
        if (json.has("required_age")) {
            requiredAge = json.get("required_age").getAsInt();
        }
        int minLevel = 5;
        int maxLevel = 5;
        if (json.has("min_level")) {
            minLevel = json.get("min_level").getAsInt();
        }
        if (json.has("max_level")) {
            maxLevel = json.get("max_level").getAsInt();
        }
        double shinyOdds = 0.0;
        if (json.has("shiny_odds")) {
            shinyOdds = json.get("shiny_odds").getAsDouble();
        }
        ArrayList<String> aspects = new ArrayList<String>();
        if (json.has("aspects") && json.get("aspects").isJsonArray()) {
            json.get("aspects").getAsJsonArray().forEach(element -> {
                if (element.isJsonPrimitive()) {
                    aspects.add(element.getAsString());
                }
            });
        }
        HashMap<String, Integer> ivs = new HashMap<String, Integer>();
        HashMap<String, Integer> ivsMax = new HashMap<String, Integer>();
        if (json.has("ivs") && json.get("ivs").isJsonObject()) {
            String[] statKeys;
            JsonObject ivsObj = json.get("ivs").getAsJsonObject();
            for (String stat : statKeys = new String[]{"hp", "attack", "defense", "special_attack", "special_defense", "speed"}) {
                if (!ivsObj.has(stat)) continue;
                if (ivsObj.get(stat).isJsonArray()) {
                    JsonArray array = ivsObj.get(stat).getAsJsonArray();
                    if (array.size() < 2) continue;
                    int min = Math.max(0, Math.min(31, array.get(0).getAsInt()));
                    int max = Math.max(0, Math.min(31, array.get(1).getAsInt()));
                    ivs.put(stat, Math.min(min, max));
                    ivsMax.put(stat, Math.max(min, max));
                    continue;
                }
                if (!ivsObj.get(stat).isJsonPrimitive()) continue;
                int value = Math.max(0, Math.min(31, ivsObj.get(stat).getAsInt()));
                ivs.put(stat, value);
                ivsMax.put(stat, value);
            }
        }
        boolean cancelDrops = false;
        if (json.has("cancel_drops")) {
            cancelDrops = json.get("cancel_drops").getAsBoolean();
        }
        return new CropSpawnConfig(blockId, cobblemonId, odds, requiredAge, minLevel, maxLevel, shinyOdds, aspects, ivs, ivsMax, cancelDrops);
    }

    public boolean matches(class_2680 state) {
        class_2960 blockLocation = class_7923.field_41175.method_10221((Object)state.method_26204());
        if (!blockLocation.toString().equals(this.blockId)) {
            return false;
        }
        if (this.requiredAge == null) {
            return true;
        }
        Optional<class_2758> ageProperty = this.findAgeProperty(state);
        if (ageProperty.isPresent()) {
            Integer currentAge = (Integer)state.method_11654((class_2769)ageProperty.get());
            return currentAge.equals(this.requiredAge);
        }
        return false;
    }

    private Optional<class_2758> findAgeProperty(class_2680 state) {
        class_2758 intProp;
        for (class_2769 property : state.method_28501()) {
            if (!(property instanceof class_2758)) continue;
            intProp = (class_2758)property;
            String name = property.method_11899().toLowerCase();
            if (!name.equals("age") && !name.equals("stage")) continue;
            return Optional.of(intProp);
        }
        for (class_2769 property : state.method_28501()) {
            if (!(property instanceof class_2758)) continue;
            intProp = (class_2758)property;
            return Optional.of(intProp);
        }
        return Optional.empty();
    }

    public String getBlockId() {
        return this.blockId;
    }

    public String getCobblemonId() {
        return this.cobblemonId;
    }

    public double getOdds() {
        return this.odds;
    }

    public Integer getRequiredAge() {
        return this.requiredAge;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public double getShinyOdds() {
        return this.shinyOdds;
    }

    public List<String> getAspects() {
        return new ArrayList<String>(this.aspects);
    }

    public Map<String, Integer> getIvs() {
        return new HashMap<String, Integer>(this.ivs);
    }

    public Map<String, Integer> getIvsMax() {
        return new HashMap<String, Integer>(this.ivsMax);
    }

    public boolean shouldCancelDrops() {
        return this.cancelDrops;
    }
}

