/*
 * Decompiled with CFR 0.152.
 */
package ca.diggsly.fabric.data;

import ca.diggsly.fabric.data.CropSpawnConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CropSpawnLoader
implements SimpleSynchronousResourceReloadListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CropSpawnLoader.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String DIRECTORY = "growamon";
    private static final List<CropSpawnConfig> configs = new ArrayList<CropSpawnConfig>();

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)DIRECTORY, (String)"crop_spawns");
    }

    public void method_14491(class_3300 manager) {
        configs.clear();
        Map resources = manager.method_14488(DIRECTORY, path -> path.method_12832().endsWith(".json"));
        LOGGER.info("Loading Grow-A-Mon crop spawn configurations...");
        int loadedCount = 0;
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(((class_3298)entry.getValue()).method_14482(), StandardCharsets.UTF_8));){
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                CropSpawnConfig config = CropSpawnConfig.fromJson(json);
                configs.add(config);
                ++loadedCount;
                StringBuilder logMessage = new StringBuilder();
                logMessage.append(String.format("Loaded crop spawn config from %s: %s -> %s (%.1f%% chance)", id, config.getBlockId(), config.getCobblemonId(), config.getOdds() * 100.0));
                if (config.getMinLevel() != config.getMaxLevel()) {
                    logMessage.append(String.format(", levels %d-%d", config.getMinLevel(), config.getMaxLevel()));
                } else {
                    logMessage.append(String.format(", level %d", config.getMinLevel()));
                }
                if (config.getShinyOdds() > 0.0) {
                    logMessage.append(String.format(", %.1f%% shiny", config.getShinyOdds() * 100.0));
                }
                if (!config.getAspects().isEmpty()) {
                    logMessage.append(String.format(", aspects: %s", String.join((CharSequence)", ", config.getAspects())));
                }
                if (!config.getIvs().isEmpty()) {
                    logMessage.append(", IVs: {");
                    boolean first = true;
                    for (String stat : new String[]{"hp", "attack", "defense", "special_attack", "special_defense", "speed"}) {
                        if (!config.getIvs().containsKey(stat)) continue;
                        if (!first) {
                            logMessage.append(", ");
                        }
                        logMessage.append(stat.replace("_", " ")).append(": ");
                        int min = config.getIvs().get(stat);
                        int max = config.getIvsMax().get(stat);
                        if (min == max) {
                            logMessage.append(min);
                        } else {
                            logMessage.append(min).append("-").append(max);
                        }
                        first = false;
                    }
                    logMessage.append("}");
                }
                if (config.shouldCancelDrops()) {
                    logMessage.append(", cancel drops");
                }
                LOGGER.info(logMessage.toString());
            }
            catch (Exception e) {
                LOGGER.error("Failed to load crop spawn config from {}", (Object)id, (Object)e);
            }
        }
        LOGGER.info("Loaded {} Grow-A-Mon crop spawn configuration(s)", (Object)loadedCount);
    }

    public static List<CropSpawnConfig> getConfigs() {
        return new ArrayList<CropSpawnConfig>(configs);
    }
}

