/*
 * Decompiled with CFR 0.152.
 */
package net.animalplus.commands;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.animalplus.commands.CommandList;
import net.animalplus.commands.MobSettings;

public class ConfigManager {
    private final String APPDATA = System.getenv("APPDATA");
    private final String CONFIG_PATH = this.APPDATA + "\\.minecraft\\config\\animal_plus_config.json";
    private static Map<String, MobSettings> mobSettingsMap = new HashMap<String, MobSettings>();

    public void saveConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = new File(this.CONFIG_PATH);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson(mobSettingsMap, (Appendable)writer);
            System.out.println("Saved config to: " + file.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Type type = new TypeToken<Map<String, MobSettings>>(){}.getType();
        File file = new File(this.CONFIG_PATH);
        System.out.println("Loading config from: " + file.getAbsolutePath());
        try (FileReader reader = new FileReader(file);){
            mobSettingsMap = (Map)gson.fromJson((Reader)reader, type);
            if (mobSettingsMap == null) {
                mobSettingsMap = new HashMap<String, MobSettings>();
            }
            System.out.println("Loaded config: " + String.valueOf(mobSettingsMap));
        }
        catch (FileNotFoundException e) {
            System.out.println("Config not found, creating new one...");
            mobSettingsMap = new HashMap<String, MobSettings>();
            this.saveConfig();
        }
        catch (Exception e) {
            System.out.println("Error loading config, resetting...");
            e.printStackTrace();
            mobSettingsMap = new HashMap<String, MobSettings>();
            this.saveConfig();
        }
    }

    public void setCoolDown(String mobName, CommandList.SubArgs subCommand, int cooldown) {
        MobSettings settings = mobSettingsMap.get(mobName);
        if (settings != null) {
            if (subCommand.equals((Object)CommandList.SubArgs.AGE)) {
                settings.setAgeCooldown(cooldown);
            }
            if (subCommand.equals((Object)CommandList.SubArgs.BREED)) {
                settings.setBreedCooldown(cooldown);
            }
        } else {
            this.addMobIfMissing(mobName);
            settings = new MobSettings(mobName, 24000, 6000);
            mobSettingsMap.put(mobName, settings);
            this.setCoolDown(mobName, subCommand, cooldown);
        }
        this.saveConfig();
    }

    public void setReset(String mobName, CommandList.SubArgs subCommand) {
        MobSettings settings = mobSettingsMap.get(mobName);
        if (settings != null) {
            if (subCommand.equals((Object)CommandList.SubArgs.AGE)) {
                settings.resetAgeCD();
            }
            if (subCommand.equals((Object)CommandList.SubArgs.BREED)) {
                settings.resetBreedCD();
            }
        } else {
            this.addMobIfMissing(mobName);
            settings = new MobSettings(mobName, 24000, 6000);
            mobSettingsMap.put(mobName, settings);
            this.setReset(mobName, subCommand);
        }
        this.saveConfig();
    }

    public int getAgeCooldownOrAdd(String mobName) {
        MobSettings settings = mobSettingsMap.get(mobName);
        if (settings == null) {
            this.addMobIfMissing(mobName);
            settings = mobSettingsMap.get(mobName);
        }
        return settings.getAgeCooldown();
    }

    public int getBreedCooldownOrAdd(String mobName) {
        MobSettings settings = mobSettingsMap.get(mobName);
        if (settings == null) {
            this.addMobIfMissing(mobName);
            settings = mobSettingsMap.get(mobName);
        }
        return settings.getBreedCooldown();
    }

    public void addMobIfMissing(String mobName) {
        if (!mobSettingsMap.containsKey(mobName)) {
            MobSettings settings = new MobSettings(mobName, 24000, 6000);
            mobSettingsMap.put(mobName, settings);
            this.saveConfig();
            System.out.println("Added new mob to config: " + mobName);
        }
    }
}

