/*
 * Decompiled with CFR 0.152.
 */
package net.animalplus.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.animalplus.commands.CommandList;
import net.animalplus.commands.ConfigManager;
import net.animalplus.commands.MobSettings;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class MobManager {
    private final Map<Mob, Integer> DELAYED_MOBS = new HashMap<Mob, Integer>();
    public static int TICKLEFT = 20;
    private final int TICKTOMIN = 1200;
    private ConfigManager configManager;

    public MobManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    private int getAgeCooldown(String mobName) {
        return this.configManager.getAgeCooldownOrAdd(mobName);
    }

    private int getBreedCooldown(String mobName) {
        return this.configManager.getBreedCooldownOrAdd(mobName);
    }

    @SubscribeEvent
    public void babyMobSpawn(BabyEntitySpawnEvent event) {
        Mob parentA = event.getParentA();
        Mob parentB = event.getParentB();
        AgeableMob child = event.getChild();
        this.DELAYED_MOBS.put((Mob)child, TICKLEFT);
        this.DELAYED_MOBS.put(parentA, TICKLEFT);
        this.DELAYED_MOBS.put(parentB, TICKLEFT);
    }

    @SubscribeEvent
    public void handleMobDelays(ServerTickEvent.Post event) {
        if (this.DELAYED_MOBS.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Mob, Integer>> it = this.DELAYED_MOBS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Mob, Integer> entry = it.next();
            Mob mob = entry.getKey();
            int ticksLeft = entry.getValue() - 1;
            if (ticksLeft <= 0) {
                if (mob instanceof Animal) {
                    Animal animal = (Animal)mob;
                    String mobName = animal.getName().getString().toLowerCase();
                    if (animal.isBaby()) {
                        int ageCD = this.getAgeCooldown(mobName);
                        animal.setAge(-ageCD);
                    } else {
                        int breedCD = this.getBreedCooldown(mobName);
                        animal.setAge(breedCD);
                    }
                }
                it.remove();
                continue;
            }
            entry.setValue(ticksLeft);
        }
    }

    public int handleCommands(CommandContext<CommandSourceStack> context, MobSettings mobSettings) {
        String command = ((ParsedCommandNode)context.getNodes().get(2)).getNode().getName();
        CommandList cmd = CommandList.fromString(command);
        CommandList.SubArgs subCmd = null;
        int seconds = 0;
        if (!command.equals(CommandList.check.toString())) {
            try {
                String subCommand = ((ParsedCommandNode)context.getNodes().get(3)).getNode().getName();
                subCmd = CommandList.SubArgs.fromString(subCommand);
                seconds = IntegerArgumentType.getInteger(context, (String)CommandList.SubArgs.SECONDS.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cmd != null) {
            switch (cmd) {
                case check: {
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("Current cooldowns for %s: Age = %d %s, Breed = %d %s", new Object[]{mobSettings.getName(), this.getAgeCooldown(mobSettings.getName()), CommandList.SubArgs.SECONDS, this.getBreedCooldown(mobSettings.getName()), CommandList.SubArgs.SECONDS})).withStyle(ChatFormatting.DARK_GREEN));
                    return 1;
                }
                case change: {
                    this.configManager.setCoolDown(mobSettings.getName(), subCmd, seconds);
                    if (subCmd.equals((Object)CommandList.SubArgs.AGE)) {
                        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("Age cooldown for %s changed to %d seconds", mobSettings.getName(), seconds)).withStyle(ChatFormatting.GREEN));
                        return 1;
                    }
                    if (subCmd.equals((Object)CommandList.SubArgs.BREED)) {
                        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("Breed cooldown for %s changed to %d seconds", mobSettings.getName(), seconds)).withStyle(ChatFormatting.GREEN));
                        return 1;
                    }
                    return 1;
                }
                case reset: {
                    this.configManager.setReset(mobSettings.getName(), subCmd);
                    if (subCmd.equals((Object)CommandList.SubArgs.AGE)) {
                        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("Age cooldown for %s has been reset to default (%d mins)", mobSettings.getName(), 20)).withStyle(ChatFormatting.DARK_RED));
                    }
                    if (subCmd.equals((Object)CommandList.SubArgs.BREED)) {
                        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("Breed cooldown for %s has been reset to default (%d mins)", mobSettings.getName(), 5)).withStyle(ChatFormatting.DARK_RED));
                    }
                    return 1;
                }
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)String.format("Unknown command %s", command)));
            return 1;
        }
        return 1;
    }

    private void printDebugInfo(Mob mob, boolean toggleDebugInfo) {
        if (!toggleDebugInfo) {
            return;
        }
        Animal mobAnimal = (Animal)mob;
        double x = mobAnimal.getX();
        double y = mobAnimal.getY();
        double z = mobAnimal.getZ();
        for (Player player : mobAnimal.level().players()) {
            ServerPlayer serverPlayer;
            if (!(player instanceof ServerPlayer) || !(serverPlayer = (ServerPlayer)player).hasPermissions(2)) continue;
            String tpCommand = String.format("/tp %s %.2f %.2f %.2f", serverPlayer.getName().getString(), x, y, z);
            MutableComponent tpMsg = Component.literal((String)"[Teleport]").withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, tpCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to teleport to this mob!"))));
            MutableComponent fullMsg = Component.literal((String)"Debug Info: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)("Baby " + mobAnimal.getType().toShortString())).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)(" | Age: " + mobAnimal.getAge())).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)String.format(" | (x %.2f, y %.2f, z %.2f)", x, y, z)).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)" ")).append((Component)tpMsg);
            serverPlayer.sendSystemMessage((Component)fullMsg);
        }
    }
}

