/*
 * Decompiled with CFR 0.152.
 */
package net.animalplus.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.animalplus.commands.CommandList;
import net.animalplus.commands.ConfigManager;
import net.animalplus.commands.MobManager;
import net.animalplus.commands.MobSettings;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

public class ModCommand {
    private static Set<String> AGEABLE_MOBS = new HashSet<String>();
    private ConfigManager configManager;
    private MobManager mobManager;

    public ModCommand(ConfigManager configManager, MobManager mobManager) {
        this.configManager = configManager;
        this.mobManager = mobManager;
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        RequiredArgumentBuilder mobArg = Commands.argument((String)CommandList.SubArgs.ANIMAL.toString(), (ArgumentType)StringArgumentType.word()).suggests(this::mobSuggestions);
        mobArg.then(this.registerReset());
        mobArg.then(this.registerChange());
        mobArg.then(this.registerCheck());
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"animalplus").then((ArgumentBuilder)mobArg));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        ServerLevel level = event.getServer().overworld();
        this.getAllAgeableMobNamesString((Level)level);
        Set updated = AGEABLE_MOBS.stream().map(mob -> {
            int idx = mob.lastIndexOf(58);
            return idx != -1 ? mob.substring(idx + 1) : mob;
        }).collect(Collectors.toSet());
        AGEABLE_MOBS.clear();
        AGEABLE_MOBS.addAll(updated);
    }

    private void getAllAgeableMobNamesString(Level level) {
        for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
            ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)type);
            if (id == null) continue;
            try {
                Entity entity = type.create(level);
                if (!(entity instanceof AgeableMob)) continue;
                AGEABLE_MOBS.add(id.toString());
            }
            catch (Exception exception) {}
        }
    }

    private LiteralArgumentBuilder<CommandSourceStack> registerCheck() {
        return (LiteralArgumentBuilder)Commands.literal((String)CommandList.check.toString()).executes(this::handleCommand);
    }

    private LiteralArgumentBuilder<CommandSourceStack> registerReset() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)CommandList.reset.toString()).then(this.registerAge(CommandList.reset))).then(this.registerBreed(CommandList.reset));
    }

    private LiteralArgumentBuilder<CommandSourceStack> registerChange() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)CommandList.change.toString()).then(this.registerAge(CommandList.change))).then(this.registerBreed(CommandList.change))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Usage: /mobagetweak <mob> change <age|breed> <seconds>"));
            return 0;
        });
    }

    private LiteralArgumentBuilder<CommandSourceStack> registerAge(CommandList commandList) {
        if (commandList.equals((Object)CommandList.reset)) {
            return (LiteralArgumentBuilder)Commands.literal((String)CommandList.SubArgs.AGE.toString()).executes(this::handleCommand);
        }
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)CommandList.SubArgs.AGE.toString()).then(Commands.argument((String)CommandList.SubArgs.SECONDS.toString(), (ArgumentType)IntegerArgumentType.integer((int)1, (int)1200)).executes(this::handleCommand))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"You must provide seconds for age. Usage: /mobagetweak <mob> change age <1-1200>"));
            return 0;
        });
    }

    private LiteralArgumentBuilder<CommandSourceStack> registerBreed(CommandList commandList) {
        if (commandList.equals((Object)CommandList.reset)) {
            return (LiteralArgumentBuilder)Commands.literal((String)CommandList.SubArgs.BREED.toString()).executes(this::handleCommand);
        }
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)CommandList.SubArgs.BREED.toString()).then(Commands.argument((String)CommandList.SubArgs.SECONDS.toString(), (ArgumentType)IntegerArgumentType.integer((int)1, (int)600)).executes(this::handleCommand))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"You must provide seconds for breed. Usage: /mobagetweak <mob> change breed <1-600>"));
            return 0;
        });
    }

    private CompletableFuture<Suggestions> mobSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        for (String mob : AGEABLE_MOBS) {
            int idx = mob.indexOf(":");
            builder.suggest(mob);
        }
        return builder.buildFuture();
    }

    private int handleCommand(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source;
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        boolean isSingleplayer = server.isSingleplayer();
        if (!isSingleplayer && !(source = (CommandSourceStack)context.getSource()).hasPermission(2)) {
            source.sendFailure((Component)Component.literal((String)"You do not have permission to execute this command."));
            return 1;
        }
        String mobName = StringArgumentType.getString(context, (String)CommandList.SubArgs.ANIMAL.toString());
        if (!AGEABLE_MOBS.contains(mobName)) {
            String msg = String.format("Error: %s not found", mobName);
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)msg));
            return 1;
        }
        MobSettings mobSettings = new MobSettings(mobName, 24000, 6000);
        return this.mobManager.handleCommands(context, mobSettings);
    }
}

