/*
 * Decompiled with CFR 0.152.
 */
package net.animalplus.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.animalplus.entity.client.BrownCowAnimations;
import net.animalplus.entity.custom.BrownCowEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class BrownCowModel<T extends BrownCowEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"animalplus", (String)"brown_cow"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart Rbackleg;
    private final ModelPart Lbackleg;
    private final ModelPart Rfrontleg;
    private final ModelPart Lfrontleg;

    public BrownCowModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.Rbackleg = root.getChild("Rbackleg");
        this.Lbackleg = root.getChild("Lbackleg");
        this.Rfrontleg = root.getChild("Rfrontleg");
        this.Lfrontleg = root.getChild("Lfrontleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)-5.0f));
        PartDefinition mlikpart_r1 = body.addOrReplaceChild("mlikpart_r1", CubeListBuilder.create().texOffs(52, 0).addBox(-2.0f, 2.0f, -8.0f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(18, 4).addBox(-6.0f, -10.0f, -7.0f, 12.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)7.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(-5.0f, -5.0f, -4.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(4.0f, -5.0f, -4.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)-8.0f));
        PartDefinition Rbackleg = partdefinition.addOrReplaceChild("Rbackleg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)12.0f, (float)7.0f));
        PartDefinition Lbackleg = partdefinition.addOrReplaceChild("Lbackleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)12.0f, (float)7.0f));
        PartDefinition Rfrontleg = partdefinition.addOrReplaceChild("Rfrontleg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)12.0f, (float)-6.0f));
        PartDefinition Lfrontleg = partdefinition.addOrReplaceChild("Lfrontleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -1.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)12.0f, (float)-6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(BrownCowEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(BrownCowAnimations.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(entity.idleAnimationState, BrownCowAnimations.idle, ageInTicks, 1.0f);
        this.animate(entity.deathAnimationState, BrownCowAnimations.death, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.Rbackleg.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.Lbackleg.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.Rfrontleg.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.Lfrontleg.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

