/*
 * Decompiled with CFR 0.152.
 */
package net.animalplus.item;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AgeWandItem
extends Item {
    public AgeWandItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (!player.level().isClientSide && target instanceof Animal) {
            CompoundTag fullNbt;
            Animal animal = (Animal)target;
            if (target.isBaby() && animal.saveAsPassenger(fullNbt = new CompoundTag())) {
                int age = -animal.getAge();
                int totalSeconds = age / 20;
                int minutes = totalSeconds / 60;
                int seconds = totalSeconds % 60;
                String msg = minutes > 0 && seconds > 0 ? "Cooldown: " + minutes + " minutes and " + seconds + " seconds" : (minutes > 0 ? "Cooldown: " + minutes + " minutes" : "Cooldown: " + seconds + " seconds");
                player.displayClientMessage((Component)Component.literal((String)msg), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }
}

