/*
 * Decompiled with CFR 0.152.
 */
package net.animalplus.item;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GrowWandItem
extends Item {
    public GrowWandItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (!player.level().isClientSide && target instanceof Animal) {
            Animal animal = (Animal)target;
            if (target.isBaby()) {
                CompoundTag nbt = new CompoundTag();
                target.saveWithoutId(nbt);
                nbt.putInt("Age", 0);
                animal.load(nbt);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.getItemInHand(hand).hurtAndBreak(1, serverPlayer.serverLevel(), (LivingEntity)player, item -> player.onEquippedItemBroken(item, EquipmentSlot.MAINHAND));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }
}

