/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.trade;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Lifecycle;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.config.ConfigManager;
import net.borisshoes.borislib.config.ConfigSetting;
import net.borisshoes.borislib.config.ConfigValue;
import net.borisshoes.borislib.config.IConfigSetting;
import net.borisshoes.borislib.config.values.EnumConfigValue;
import net.borisshoes.borislib.config.values.IntConfigValue;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.utils.TextUtils;
import net.borisshoes.trade.TradeSelectionGui;
import net.borisshoes.trade.TradeSession;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Trade
implements ModInitializer {
    private static final Logger logger = LogManager.getLogger((String)"Trade");
    private static final String CONFIG_NAME = "Trade.properties";
    public static final String MOD_ID = "trade";
    public static final class_2378<IConfigSetting<?>> CONFIG_SETTINGS = new class_2370(class_5321.method_29180((class_2960)class_2960.method_60655((String)"trade", (String)"config_settings")), Lifecycle.stable());
    private static final ArrayList<TradeRequest> ACTIVE_TRADES = new ArrayList();
    private static final HashMap<UUID, Long> RECENT_REQUESTS = new HashMap();
    public static ConfigManager CONFIG;
    public static final IConfigSetting<?> TIMEOUT_CFG;
    public static final IConfigSetting<?> COOLDOWN_CFG;
    public static final IConfigSetting<?> COOLDOWN_MODE_CFG;
    public static final GraphicalItem.GraphicElement GREEN_CONFIRM;
    public static final GraphicalItem.GraphicElement YELLOW_CONFIRM;
    public static final GraphicalItem.GraphicElement RED_CONFIRM;

    private static IConfigSetting<?> registerConfigSetting(IConfigSetting<?> setting) {
        class_2378.method_10230(CONFIG_SETTINGS, (class_2960)class_2960.method_60655((String)MOD_ID, (String)setting.getId()), setting);
        return setting;
    }

    @Nullable
    private static CompletableFuture<Suggestions> filterSuggestionsByInput(SuggestionsBuilder builder, List<String> values) {
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        values.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> getTradeInitSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        class_2168 scs = (class_2168)context.getSource();
        List<String> activeTargets = Stream.concat(ACTIVE_TRADES.stream().map(tradeRequest -> tradeRequest.tTo.method_5477().getString()), ACTIVE_TRADES.stream().map(tradeRequest -> tradeRequest.tFrom.method_5477().getString())).toList();
        List<String> others = Arrays.stream(scs.method_9211().method_3858()).filter(s -> !s.equals(scs.method_9214()) && !activeTargets.contains(s)).collect(Collectors.toList());
        return Trade.filterSuggestionsByInput(builder, others);
    }

    private CompletableFuture<Suggestions> getTradeTargetSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        List<String> activeTargets = ACTIVE_TRADES.stream().map(tradeRequest -> tradeRequest.tFrom.method_5477().getString()).collect(Collectors.toList());
        return Trade.filterSuggestionsByInput(builder, activeTargets);
    }

    private CompletableFuture<Suggestions> getTradeSenderSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        List<String> activeTargets = ACTIVE_TRADES.stream().map(tradeRequest -> tradeRequest.tTo.method_5477().getString()).collect(Collectors.toList());
        return Trade.filterSuggestionsByInput(builder, activeTargets);
    }

    public void onInitialize() {
        logger.info("Initializing Trade...");
        CONFIG = new ConfigManager(MOD_ID, "Trade", CONFIG_NAME, CONFIG_SETTINGS);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, registrationEnvironment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).executes(Trade::openTradeSelector)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).suggests(this::getTradeInitSuggestions).executes(ctx -> Trade.tradeInit((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tradeaccept").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).suggests(this::getTradeTargetSuggestions).executes(ctx -> Trade.tradeAccept((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"))))).executes(ctx -> Trade.tradeAccept((CommandContext<class_2168>)ctx, null)));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tradedeny").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).suggests(this::getTradeTargetSuggestions).executes(ctx -> Trade.tradeDeny((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"))))).executes(ctx -> Trade.tradeDeny((CommandContext<class_2168>)ctx, null)));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tradecancel").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).suggests(this::getTradeSenderSuggestions).executes(ctx -> Trade.tradeCancel((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"))))).executes(ctx -> Trade.tradeCancel((CommandContext<class_2168>)ctx, null)));
            dispatcher.register(CONFIG.generateCommand("trademod", "config"));
        });
        PolymerResourcePackUtils.addModAssets((String)MOD_ID);
    }

    private static int openTradeSelector(CommandContext<class_2168> ctx) {
        class_3222 trader = ((class_2168)ctx.getSource()).method_44023();
        if (trader == null) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"text.trade.must_be_player").method_27692(class_124.field_1061));
            return -1;
        }
        TradeSelectionGui gui = new TradeSelectionGui(trader);
        return 1;
    }

    public static int tradeInit(CommandContext<class_2168> ctx, class_3222 tTo) throws CommandSyntaxException {
        class_3222 tFrom = ((class_2168)ctx.getSource()).method_44023();
        if (tFrom == null) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"text.trade.must_be_player").method_27692(class_124.field_1061));
            return -1;
        }
        return Trade.tradeInit(tFrom, tTo);
    }

    public static int tradeInit(class_3222 tFrom, class_3222 tTo) {
        if (tFrom == null) {
            return -1;
        }
        if (tFrom.equals((Object)tTo)) {
            tFrom.method_7353((class_2561)class_2561.method_43471((String)"text.trade.cannot_trade_self").method_27692(class_124.field_1061), false);
            return -1;
        }
        if (Trade.checkCooldown(tFrom)) {
            return 1;
        }
        TradeRequest tr = new TradeRequest(tFrom, tTo, CONFIG.getInt(TIMEOUT_CFG) * 1000);
        if (ACTIVE_TRADES.stream().anyMatch(tpaRequest -> tpaRequest.equals(tr))) {
            tFrom.method_7353((class_2561)class_2561.method_43471((String)"text.trade.already_requested").method_27692(class_124.field_1061), false);
            return -1;
        }
        tr.setTimeoutCallback(() -> {
            ACTIVE_TRADES.remove(tr);
            tFrom.method_7353((class_2561)class_2561.method_43469((String)"text.trade.trade_to_timeout", (Object[])new Object[]{tTo.method_5477().getString()}).method_27692(class_124.field_1061), false);
            tTo.method_7353((class_2561)class_2561.method_43469((String)"text.trade.trade_from_timeout", (Object[])new Object[]{tFrom.method_5477().getString()}).method_27692(class_124.field_1061), false);
        });
        ACTIVE_TRADES.add(tr);
        tFrom.method_7353((class_2561)class_2561.method_43469((String)"text.trade.you_requested", (Object[])new Object[]{class_2561.method_43470((String)tTo.method_5477().getString()).method_27692(class_124.field_1075), class_2561.method_43470((String)"/tradecancel [<player>]").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tradecancel " + tTo.method_5477().getString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tradecancel " + tTo.method_5477().getString())))).method_10977(class_124.field_1065)), class_2561.method_43470((String)TextUtils.readableInt((int)CONFIG.getInt(TIMEOUT_CFG)))}).method_27692(class_124.field_1060), false);
        tTo.method_7353((class_2561)class_2561.method_43469((String)"text.trade.they_requested", (Object[])new Object[]{class_2561.method_43470((String)tFrom.method_5477().getString()).method_27692(class_124.field_1075), class_2561.method_43470((String)"/tradeaccept [<player>]").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tradeaccept " + tFrom.method_5477().getString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tradeaccept " + tFrom.method_5477().getString())))).method_10977(class_124.field_1065)), class_2561.method_43470((String)"/tradedeny [<player>]").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tradedeny " + tFrom.method_5477().getString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tradedeny " + tFrom.method_5477().getString())))).method_10977(class_124.field_1065)), class_2561.method_43470((String)TextUtils.readableInt((int)CONFIG.getInt(TIMEOUT_CFG)))}).method_27692(class_124.field_1060), false);
        return 1;
    }

    public static int tradeAccept(CommandContext<class_2168> ctx, class_3222 tFrom) throws CommandSyntaxException {
        TradeRequest tr;
        class_3222 tTo = ((class_2168)ctx.getSource()).method_44023();
        if (tTo == null) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"text.trade.must_be_player").method_27692(class_124.field_1061));
            return -1;
        }
        if (tFrom == null) {
            TradeRequest[] candidates = (TradeRequest[])ACTIVE_TRADES.stream().filter(tpaRequest -> tpaRequest.tTo.equals((Object)tTo)).toArray(TradeRequest[]::new);
            if (candidates.length > 1) {
                class_5250 text = class_2561.method_43471((String)"text.trade.accept_specify").method_10852((class_2561)class_2561.method_43470((String)"\n")).method_27692(class_124.field_1060);
                Arrays.stream(candidates).map(tpaRequest -> tpaRequest.tFrom.method_5477().getString()).forEach(name -> text.method_10852((class_2561)class_2561.method_43470((String)name).method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tradeaccept " + name)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tradeaccept " + name)))).method_10977(class_124.field_1065))).method_27693(" "));
                tTo.method_7353((class_2561)text, false);
                return 1;
            }
            if (candidates.length < 1) {
                tTo.method_7353((class_2561)class_2561.method_43471((String)"text.trade.no_requests").method_27692(class_124.field_1061), false);
                return 1;
            }
            tFrom = candidates[0].tFrom;
        }
        if ((tr = Trade.getTradeRequest(tFrom, tTo, TradeAction.ACCEPT)) == null) {
            return 1;
        }
        new TradeSession(tFrom, tTo, tr);
        tr.cancelTimeout();
        ACTIVE_TRADES.remove(tr);
        tr.tTo.method_7353((class_2561)class_2561.method_43471((String)"text.trade.you_accept"), false);
        tr.tFrom.method_7353((class_2561)class_2561.method_43469((String)"text.trade.they_accept", (Object[])new Object[]{class_2561.method_43470((String)tr.tTo.method_5477().getString()).method_27692(class_124.field_1075)}).method_27692(class_124.field_1060), false);
        return 1;
    }

    public static int tradeDeny(CommandContext<class_2168> ctx, class_3222 tFrom) throws CommandSyntaxException {
        TradeRequest tr;
        class_3222 tTo = ((class_2168)ctx.getSource()).method_44023();
        if (tFrom == null) {
            TradeRequest[] candidates = (TradeRequest[])ACTIVE_TRADES.stream().filter(tpaRequest -> tpaRequest.tTo.equals((Object)tTo)).toArray(TradeRequest[]::new);
            if (candidates.length > 1) {
                class_5250 text = class_2561.method_43471((String)"text.trade.deny_specify").method_10852((class_2561)class_2561.method_43470((String)"\n")).method_27692(class_124.field_1060);
                Arrays.stream(candidates).map(tpaRequest -> tpaRequest.tFrom.method_5477().getString()).forEach(name -> text.method_10852((class_2561)class_2561.method_43470((String)name).method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tradedeny " + name)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tradedeny " + name)))).method_10977(class_124.field_1065))).method_27693(" "));
                tTo.method_7353((class_2561)text, false);
                return 1;
            }
            if (candidates.length < 1) {
                tTo.method_7353((class_2561)class_2561.method_43471((String)"text.trade.no_requests").method_27692(class_124.field_1061), false);
                return 1;
            }
            tFrom = candidates[0].tFrom;
        }
        if ((tr = Trade.getTradeRequest(tFrom, tTo, TradeAction.DENY)) == null) {
            return 1;
        }
        tr.cancelTimeout();
        ACTIVE_TRADES.remove(tr);
        tr.tTo.method_7353((class_2561)class_2561.method_43471((String)"gui.trade.you_cancelled"), false);
        tr.tFrom.method_7353((class_2561)class_2561.method_43469((String)"gui.trade.they_cancelled", (Object[])new Object[]{class_2561.method_43470((String)tr.tTo.method_5477().getString()).method_27692(class_124.field_1075)}).method_27692(class_124.field_1061), false);
        return 1;
    }

    public static int tradeCancel(CommandContext<class_2168> ctx, class_3222 tTo) throws CommandSyntaxException {
        TradeRequest tr;
        class_3222 tFrom = ((class_2168)ctx.getSource()).method_44023();
        if (tTo == null) {
            TradeRequest[] candidates = (TradeRequest[])ACTIVE_TRADES.stream().filter(tpaRequest -> tpaRequest.tFrom.equals((Object)tFrom)).toArray(TradeRequest[]::new);
            if (candidates.length > 1) {
                class_5250 text = class_2561.method_43471((String)"text.trade.cancel_specify").method_10852((class_2561)class_2561.method_43470((String)"\n")).method_27692(class_124.field_1060);
                Arrays.stream(candidates).map(tpaRequest -> tpaRequest.tTo.method_5477().getString()).forEach(name -> text.method_10852((class_2561)class_2561.method_43470((String)name).method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/tradecancel " + name)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/tradecancel " + name)))).method_10977(class_124.field_1065))).method_27693(" "));
                tFrom.method_7353((class_2561)text, false);
                return 1;
            }
            if (candidates.length < 1) {
                tFrom.method_7353((class_2561)class_2561.method_43471((String)"text.trade.no_requests").method_27692(class_124.field_1061), false);
                return 1;
            }
            tTo = candidates[0].tTo;
        }
        if ((tr = Trade.getTradeRequest(tFrom, tTo, TradeAction.CANCEL)) == null) {
            return 1;
        }
        tr.cancelTimeout();
        ACTIVE_TRADES.remove(tr);
        tr.tFrom.method_7353((class_2561)class_2561.method_43471((String)"gui.trade.you_cancelled").method_27692(class_124.field_1061), false);
        tr.tTo.method_7353((class_2561)class_2561.method_43469((String)"gui.trade.they_cancelled", (Object[])new Object[]{class_2561.method_43470((String)tr.tFrom.method_5477().getString()).method_27692(class_124.field_1075)}).method_27692(class_124.field_1061), false);
        return 1;
    }

    private static TradeRequest getTradeRequest(class_3222 tFrom, class_3222 tTo, TradeAction action) {
        Optional<TradeRequest> otr = ACTIVE_TRADES.stream().filter(tpaRequest -> tpaRequest.tFrom.equals((Object)tFrom) && tpaRequest.tTo.equals((Object)tTo)).findFirst();
        if (otr.isEmpty()) {
            if (action == TradeAction.CANCEL) {
                tFrom.method_7353((class_2561)class_2561.method_43471((String)"text.trade.no_request").method_27692(class_124.field_1061), false);
            } else {
                tTo.method_7353((class_2561)class_2561.method_43471((String)"text.trade.no_request").method_27692(class_124.field_1061), false);
            }
            return null;
        }
        return otr.get();
    }

    private static boolean checkCooldown(class_3222 tFrom) {
        long diff;
        if (RECENT_REQUESTS.containsKey(tFrom.method_5667()) && (diff = Instant.now().getEpochSecond() - RECENT_REQUESTS.get(tFrom.method_5667())) < (long)CONFIG.getInt(COOLDOWN_CFG)) {
            tFrom.method_7353((class_2561)class_2561.method_43469((String)"text.trade.on_cooldown", (Object[])new Object[]{TextUtils.readableInt((int)((int)((long)CONFIG.getInt(COOLDOWN_CFG) - diff)))}).method_27692(class_124.field_1061), false);
            return true;
        }
        return false;
    }

    public static void completeSession(TradeRequest tr) {
        switch (((TradeCooldownMode)((Object)CONFIG.getValue(COOLDOWN_MODE_CFG.getName()))).ordinal()) {
            case 1: {
                RECENT_REQUESTS.put(tr.tFrom.method_5667(), Instant.now().getEpochSecond());
                RECENT_REQUESTS.put(tr.tTo.method_5667(), Instant.now().getEpochSecond());
                break;
            }
            case 0: {
                RECENT_REQUESTS.put(tr.tFrom.method_5667(), Instant.now().getEpochSecond());
            }
        }
    }

    static {
        TIMEOUT_CFG = Trade.registerConfigSetting(new ConfigSetting((ConfigValue)new IntConfigValue("timeout", Integer.valueOf(60), new IntConfigValue.IntLimits(0))));
        COOLDOWN_CFG = Trade.registerConfigSetting(new ConfigSetting((ConfigValue)new IntConfigValue("cooldown", Integer.valueOf(60), new IntConfigValue.IntLimits(0))));
        COOLDOWN_MODE_CFG = Trade.registerConfigSetting(new ConfigSetting((ConfigValue)new EnumConfigValue("cooldown-mode", (Enum)TradeCooldownMode.WHO_INITIATED, TradeCooldownMode.class)));
        GREEN_CONFIRM = BorisLib.registerGraphicItem((GraphicalItem.GraphicElement)new GraphicalItem.GraphicElement(class_2960.method_60655((String)MOD_ID, (String)"trade_confirm_green"), class_1802.field_8120, false));
        YELLOW_CONFIRM = BorisLib.registerGraphicItem((GraphicalItem.GraphicElement)new GraphicalItem.GraphicElement(class_2960.method_60655((String)MOD_ID, (String)"trade_confirm_yellow"), class_1802.field_8686, false));
        RED_CONFIRM = BorisLib.registerGraphicItem((GraphicalItem.GraphicElement)new GraphicalItem.GraphicElement(class_2960.method_60655((String)MOD_ID, (String)"trade_confirm_red"), class_1802.field_8197, false));
    }

    public static class TradeRequest {
        class_3222 tFrom;
        class_3222 tTo;
        long timeout;
        Timer timer;

        public TradeRequest(class_3222 tFrom, class_3222 tTo, int timeoutMS) {
            this.tFrom = tFrom;
            this.tTo = tTo;
            this.timeout = timeoutMS;
        }

        void setTimeoutCallback(final Timeout callback) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(this){

                @Override
                public void run() {
                    callback.onTimeout();
                }
            }, this.timeout);
        }

        void cancelTimeout() {
            this.timer.cancel();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TradeRequest that = (TradeRequest)o;
            return this.tFrom.equals((Object)that.tFrom) && this.tTo.equals((Object)that.tTo);
        }

        public int hashCode() {
            return Objects.hash(this.tFrom, this.tTo);
        }

        public String toString() {
            return "TradeRequest{tFrom=" + String.valueOf(this.tFrom) + ", tTo=" + String.valueOf(this.tTo) + "}";
        }

        public void refreshPlayers() {
            this.tFrom = this.tFrom.method_51469().method_8503().method_3760().method_14602(this.tFrom.method_5667());
            this.tTo = this.tTo.method_51469().method_8503().method_3760().method_14602(this.tTo.method_5667());
            assert (this.tFrom != null && this.tTo != null);
        }
    }

    static interface Timeout {
        public void onTimeout();
    }

    private static enum TradeAction {
        ACCEPT,
        DENY,
        CANCEL;

    }

    static enum TradeCooldownMode implements class_3542
    {
        WHO_INITIATED("WHO_INITIATED"),
        BOTH_USERS("BOTH_USERS");

        private final String name;

        private TradeCooldownMode(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

