/*
 * Decompiled with CFR 0.152.
 */
package com.awa.kissmod.client;

import com.awa.kissmod.KissMod;
import com.awa.kissmod.KissModConfig;
import com.awa.kissmod.packet.KissC2SPacket;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="kissmod", value={Dist.CLIENT})
public class KissModClient {
    public static boolean rightClickEnabled = KissModConfig.loadConfig();
    public static boolean chatMessageEnabled = KissModConfig.loadChatMessageConfig();
    public static String kissMessageFormat = KissModConfig.loadKissMessageConfig();
    public static String responseMessageFormat = KissModConfig.loadResponseMessageConfig();
    public static int kissCooldown = KissModConfig.loadKissCooldownConfig();
    public static boolean doNotDisturb = KissModConfig.loadDoNotDisturbConfig();
    private static KeyMapping kissKey;
    private static boolean wasKeyPressed;
    private static long lastTriggerTime;
    private static final long TRIGGER_INTERVAL = 175L;

    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(KissModClient::clientSetup);
        modEventBus.addListener(KissModClient::registerKeyBindings);
        MinecraftForge.EVENT_BUS.register(KissModClient.class);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
    }

    private static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        kissKey = new KeyMapping("key.kissmod.kiss", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 296, "category.kissmod.keybindings");
        event.register(kissKey);
    }

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"kissmod-rightclick").executes(context -> {
            rightClickEnabled = !rightClickEnabled;
            KissModConfig.saveConfig(rightClickEnabled);
            String translationKey = rightClickEnabled ? "kissmod.toggle.enabled" : "kissmod.toggle.disabled";
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)translationKey), false);
            return 1;
        })).then(Commands.m_82129_((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean state;
            rightClickEnabled = state = BoolArgumentType.getBool((CommandContext)context, (String)"state");
            KissModConfig.saveConfig(state);
            String translationKey = state ? "kissmod.toggle.enabled" : "kissmod.toggle.disabled";
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)translationKey), false);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"kissmod-chat").executes(context -> {
            chatMessageEnabled = !chatMessageEnabled;
            KissModConfig.saveChatMessageConfig(chatMessageEnabled);
            String translationKey = chatMessageEnabled ? "kissmod.chat.enabled" : "kissmod.chat.disabled";
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)translationKey), false);
            return 1;
        })).then(Commands.m_82129_((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean state;
            chatMessageEnabled = state = BoolArgumentType.getBool((CommandContext)context, (String)"state");
            KissModConfig.saveChatMessageConfig(state);
            String translationKey = state ? "kissmod.chat.enabled" : "kissmod.chat.disabled";
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)translationKey), false);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"kissmod-kissmsg").then(Commands.m_82129_((String)"format", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String format;
            kissMessageFormat = format = StringArgumentType.getString((CommandContext)context, (String)"format");
            KissModConfig.saveKissMessageConfig(format);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u4eb2\u543b\u6d88\u606f\u683c\u5f0f\u5df2\u8bbe\u7f6e\u4e3a: " + format)), false);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"kissmod-responsemsg").then(Commands.m_82129_((String)"format", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String format;
            responseMessageFormat = format = StringArgumentType.getString((CommandContext)context, (String)"format");
            KissModConfig.saveResponseMessageConfig(format);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u56de\u5e94\u6d88\u606f\u683c\u5f0f\u5df2\u8bbe\u7f6e\u4e3a: " + format)), false);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"kissmod-cooldown").then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int cooldown;
            kissCooldown = cooldown = IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds");
            KissModConfig.saveKissCooldownConfig(cooldown);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u4eb2\u543b\u51b7\u5374\u65f6\u95f4\u5df2\u8bbe\u7f6e\u4e3a: " + cooldown + "\u79d2")), false);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"kissmod-dnd").executes(context -> {
            doNotDisturb = !doNotDisturb;
            KissModConfig.saveDoNotDisturbConfig(doNotDisturb);
            String status = doNotDisturb ? "\u5df2\u5f00\u542f" : "\u5df2\u5173\u95ed";
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u514d\u6253\u6270\u6a21\u5f0f" + status)), false);
            return 1;
        })).then(Commands.m_82129_((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean state;
            doNotDisturb = state = BoolArgumentType.getBool((CommandContext)context, (String)"state");
            KissModConfig.saveDoNotDisturbConfig(state);
            String status = state ? "\u5df2\u5f00\u542f" : "\u5df2\u5173\u95ed";
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u514d\u6253\u6270\u6a21\u5f0f" + status)), false);
            return 1;
        })));
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Entity target;
        if (!rightClickEnabled || !event.getLevel().m_5776_()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastTriggerTime < (long)kissCooldown * 1000L) {
            return;
        }
        if (event.getEntity().m_6144_() && (target = event.getTarget()) != null) {
            UUID senderUuid = null;
            String senderName = "";
            String targetName = "";
            if (Minecraft.m_91087_().f_91074_ != null) {
                senderUuid = Minecraft.m_91087_().f_91074_.m_20148_();
                senderName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
            }
            targetName = target instanceof Player ? ((Player)target).m_7755_().getString() : target.m_7755_().getString();
            KissC2SPacket packet = new KissC2SPacket(target.m_20148_(), senderUuid, senderName, targetName, kissMessageFormat, responseMessageFormat, doNotDisturb);
            KissMod.NETWORK_CHANNEL.sendToServer((Object)packet);
            KissModClient.triggerEffect(target, event.getLevel());
            lastTriggerTime = currentTime;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        boolean isKeyPressed = kissKey != null && kissKey.m_90857_();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastTriggerTime < (long)kissCooldown * 1000L) {
            wasKeyPressed = isKeyPressed;
            return;
        }
        if (isKeyPressed && (!wasKeyPressed || currentTime - lastTriggerTime >= 175L)) {
            Minecraft client = Minecraft.m_91087_();
            Entity target = client.f_91076_;
            if (target != null && client.f_91074_ != null) {
                UUID senderUuid = client.f_91074_.m_20148_();
                String senderName = client.f_91074_.m_7755_().getString();
                String targetName = "";
                targetName = target instanceof Player ? ((Player)target).m_7755_().getString() : target.m_7755_().getString();
                KissC2SPacket packet = new KissC2SPacket(target.m_20148_(), senderUuid, senderName, targetName, kissMessageFormat, responseMessageFormat, doNotDisturb);
                KissMod.NETWORK_CHANNEL.sendToServer((Object)packet);
                if (client.f_91073_ != null) {
                    KissModClient.triggerEffect(target, (Level)client.f_91073_);
                }
                lastTriggerTime = currentTime;
            }
        }
        wasKeyPressed = isKeyPressed;
    }

    public static void triggerEffect(Entity target, Level world) {
        if (world.m_5776_()) {
            KissModClient.spawnHeartParticles(world, target);
            SoundEvent[] soundEvents = new SoundEvent[]{(SoundEvent)KissMod.CUSTOM_SOUND_EVENT.get(), (SoundEvent)KissMod.CUSTOM_SOUND1_EVENT.get(), (SoundEvent)KissMod.CUSTOM_SOUND2_EVENT.get()};
            SoundEvent randomSound = soundEvents[new Random().nextInt(soundEvents.length)];
            world.m_6263_((Player)Minecraft.m_91087_().f_91074_, target.m_20185_(), target.m_20186_(), target.m_20189_(), randomSound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void spawnHeartParticles(Level world, Entity entity) {
        if (world.m_5776_()) {
            double x = entity.m_20185_();
            double y = entity.m_20186_() + (double)entity.m_20206_();
            double z = entity.m_20189_();
            for (int i = 0; i < 20; ++i) {
                double offsetX = world.m_213780_().m_188500_() - 0.5;
                double offsetY = world.m_213780_().m_188500_() - 0.5;
                double offsetZ = world.m_213780_().m_188500_() - 0.5;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123750_, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    static {
        wasKeyPressed = false;
        lastTriggerTime = 0L;
    }
}

