/*
 * Decompiled with CFR 0.152.
 */
package com.awa.kissmod.packet;

import com.awa.kissmod.client.KissModClient;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class KissS2CPacket {
    private final UUID pattedEntityUuid;
    private final UUID whoPattedUuid;
    private final String senderName;
    private final String targetName;
    private final String kissMessageFormat;
    private final String responseMessageFormat;
    private final boolean senderDoNotDisturb;

    public KissS2CPacket(UUID pattedEntityUuid, UUID whoPattedUuid, String senderName, String targetName, String kissMessageFormat, String responseMessageFormat, boolean senderDoNotDisturb) {
        this.pattedEntityUuid = pattedEntityUuid;
        this.whoPattedUuid = whoPattedUuid;
        this.senderName = senderName;
        this.targetName = targetName;
        this.kissMessageFormat = kissMessageFormat;
        this.responseMessageFormat = responseMessageFormat;
        this.senderDoNotDisturb = senderDoNotDisturb;
    }

    public static void encode(KissS2CPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.pattedEntityUuid);
        buffer.m_130077_(packet.whoPattedUuid);
        buffer.m_130070_(packet.senderName);
        buffer.m_130070_(packet.targetName);
        buffer.m_130070_(packet.kissMessageFormat);
        buffer.m_130070_(packet.responseMessageFormat);
        buffer.writeBoolean(packet.senderDoNotDisturb);
    }

    public static KissS2CPacket decode(FriendlyByteBuf buffer) {
        UUID pattedEntityUuid = buffer.m_130259_();
        UUID whoPattedUuid = buffer.m_130259_();
        String senderName = buffer.m_130136_(Short.MAX_VALUE);
        String targetName = buffer.m_130136_(Short.MAX_VALUE);
        String kissMessageFormat = buffer.m_130136_(Short.MAX_VALUE);
        String responseMessageFormat = buffer.m_130136_(Short.MAX_VALUE);
        boolean senderDoNotDisturb = buffer.readBoolean();
        return new KissS2CPacket(pattedEntityUuid, whoPattedUuid, senderName, targetName, kissMessageFormat, responseMessageFormat, senderDoNotDisturb);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handle(KissS2CPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Minecraft client = Minecraft.m_91087_();
            ClientLevel world = client.f_91073_;
            if (world != null) {
                for (Entity entity : world.m_104735_()) {
                    if (!entity.m_20148_().equals(packet.getPattedEntityUuid()) || client.f_91074_ == null || client.f_91074_.m_20148_().equals(packet.getWhoPattedUuid())) continue;
                    KissModClient.triggerEffect(entity, (Level)world);
                    break;
                }
            }
        });
        context.setPacketHandled(true);
    }

    public UUID getPattedEntityUuid() {
        return this.pattedEntityUuid;
    }

    public UUID getWhoPattedUuid() {
        return this.whoPattedUuid;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getKissMessageFormat() {
        return this.kissMessageFormat;
    }

    public String getResponseMessageFormat() {
        return this.responseMessageFormat;
    }

    public boolean isSenderDoNotDisturb() {
        return this.senderDoNotDisturb;
    }
}

