/*
 * Decompiled with CFR 0.152.
 */
package com.awa.kissmod;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class KissModConfig {
    private static final String CONFIG_FILE = "config/kissmod.properties";
    private static final String RIGHT_CLICK_KEY = "rightClickEnabled";
    private static final String CHAT_MESSAGE_KEY = "chatMessageEnabled";
    private static final String KISS_MESSAGE_KEY = "kissMessage";
    private static final String RESPONSE_MESSAGE_KEY = "responseMessage";
    private static final String KISS_COOLDOWN_KEY = "kissCooldown";
    private static final String DO_NOT_DISTURB_KEY = "doNotDisturb";
    private static final String PLAYER_ONLY_KEY = "playerOnly";

    public static boolean loadConfig() {
        boolean bl;
        File configFile = new File(CONFIG_FILE);
        if (!configFile.exists()) {
            return true;
        }
        FileInputStream input = new FileInputStream(configFile);
        try {
            Properties prop = new Properties();
            prop.load(input);
            bl = Boolean.parseBoolean(prop.getProperty(RIGHT_CLICK_KEY, "true"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        ((InputStream)input).close();
        return bl;
    }

    public static boolean loadChatMessageConfig() {
        boolean bl;
        File configFile = new File(CONFIG_FILE);
        if (!configFile.exists()) {
            return false;
        }
        FileInputStream input = new FileInputStream(configFile);
        try {
            Properties prop = new Properties();
            prop.load(input);
            bl = Boolean.parseBoolean(prop.getProperty(CHAT_MESSAGE_KEY, "false"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        ((InputStream)input).close();
        return bl;
    }

    public static String loadKissMessageConfig() {
        String string;
        File configFile = new File(CONFIG_FILE);
        if (!configFile.exists()) {
            return "%s\u5bf9%s\u4eb2\u4e86\u4eb2\u5e76\u8bf4\u7231\u4f60\u5466~";
        }
        FileInputStream input = new FileInputStream(configFile);
        try {
            Properties prop = new Properties();
            prop.load(input);
            string = prop.getProperty(KISS_MESSAGE_KEY, "%s\u5bf9%s\u4eb2\u4e86\u4eb2\u5e76\u8bf4\u7231\u4f60\u5466~");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return "%s\u5bf9%s\u4eb2\u4e86\u4eb2\u5e76\u8bf4\u7231\u4f60\u5466~";
            }
        }
        ((InputStream)input).close();
        return string;
    }

    public static String loadResponseMessageConfig() {
        String string;
        File configFile = new File(CONFIG_FILE);
        if (!configFile.exists()) {
            return "%s\u7a9d\u4e5f\u7231\u4f60\u55b5~";
        }
        FileInputStream input = new FileInputStream(configFile);
        try {
            Properties prop = new Properties();
            prop.load(input);
            string = prop.getProperty(RESPONSE_MESSAGE_KEY, "%s\u7a9d\u4e5f\u7231\u4f60\u55b5~");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return "%s\u7a9d\u4e5f\u7231\u4f60\u55b5~";
            }
        }
        ((InputStream)input).close();
        return string;
    }

    public static int loadKissCooldownConfig() {
        int n;
        File configFile = new File(CONFIG_FILE);
        if (!configFile.exists()) {
            return 10;
        }
        FileInputStream input = new FileInputStream(configFile);
        try {
            Properties prop = new Properties();
            prop.load(input);
            n = Integer.parseInt(prop.getProperty(KISS_COOLDOWN_KEY, "10"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NumberFormatException e) {
                return 10;
            }
        }
        ((InputStream)input).close();
        return n;
    }

    public static boolean loadDoNotDisturbConfig() {
        boolean bl;
        File configFile = new File(CONFIG_FILE);
        if (!configFile.exists()) {
            return false;
        }
        FileInputStream input = new FileInputStream(configFile);
        try {
            Properties prop = new Properties();
            prop.load(input);
            bl = Boolean.parseBoolean(prop.getProperty(DO_NOT_DISTURB_KEY, "false"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        ((InputStream)input).close();
        return bl;
    }

    public static boolean loadPlayerOnlyConfig() {
        boolean bl;
        File configFile = new File(CONFIG_FILE);
        if (!configFile.exists()) {
            return true;
        }
        FileInputStream input = new FileInputStream(configFile);
        try {
            Properties prop = new Properties();
            prop.load(input);
            bl = Boolean.parseBoolean(prop.getProperty(PLAYER_ONLY_KEY, "true"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        ((InputStream)input).close();
        return bl;
    }

    public static void saveConfig(boolean state) {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        Properties prop = new Properties();
        File configFile = new File(CONFIG_FILE);
        if (configFile.exists()) {
            try (FileInputStream input2 = new FileInputStream(configFile);){
                prop.load(input2);
            }
            catch (IOException input2) {
                // empty catch block
            }
        }
        try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
            prop.setProperty(RIGHT_CLICK_KEY, String.valueOf(state));
            prop.store(output, "KissMod Configuration");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void saveChatMessageConfig(boolean state) {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        Properties prop = new Properties();
        File configFile = new File(CONFIG_FILE);
        if (configFile.exists()) {
            try (FileInputStream input2 = new FileInputStream(configFile);){
                prop.load(input2);
            }
            catch (IOException input2) {
                // empty catch block
            }
        }
        try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
            prop.setProperty(CHAT_MESSAGE_KEY, String.valueOf(state));
            prop.store(output, "KissMod Configuration");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void saveKissMessageConfig(String message) {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        Properties prop = new Properties();
        File configFile = new File(CONFIG_FILE);
        if (configFile.exists()) {
            try (FileInputStream input2 = new FileInputStream(configFile);){
                prop.load(input2);
            }
            catch (IOException input2) {
                // empty catch block
            }
        }
        try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
            prop.setProperty(KISS_MESSAGE_KEY, message);
            prop.store(output, "KissMod Configuration");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void saveResponseMessageConfig(String message) {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        Properties prop = new Properties();
        File configFile = new File(CONFIG_FILE);
        if (configFile.exists()) {
            try (FileInputStream input2 = new FileInputStream(configFile);){
                prop.load(input2);
            }
            catch (IOException input2) {
                // empty catch block
            }
        }
        try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
            prop.setProperty(RESPONSE_MESSAGE_KEY, message);
            prop.store(output, "KissMod Configuration");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void saveKissCooldownConfig(int cooldown) {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        Properties prop = new Properties();
        File configFile = new File(CONFIG_FILE);
        if (configFile.exists()) {
            try (FileInputStream input2 = new FileInputStream(configFile);){
                prop.load(input2);
            }
            catch (IOException input2) {
                // empty catch block
            }
        }
        try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
            prop.setProperty(KISS_COOLDOWN_KEY, String.valueOf(cooldown));
            prop.store(output, "KissMod Configuration");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void saveDoNotDisturbConfig(boolean state) {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        Properties prop = new Properties();
        File configFile = new File(CONFIG_FILE);
        if (configFile.exists()) {
            try (FileInputStream input2 = new FileInputStream(configFile);){
                prop.load(input2);
            }
            catch (IOException input2) {
                // empty catch block
            }
        }
        try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
            prop.setProperty(DO_NOT_DISTURB_KEY, String.valueOf(state));
            prop.store(output, "KissMod Configuration");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void savePlayerOnlyConfig(boolean state) {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        Properties prop = new Properties();
        File configFile = new File(CONFIG_FILE);
        if (configFile.exists()) {
            try (FileInputStream input2 = new FileInputStream(configFile);){
                prop.load(input2);
            }
            catch (IOException input2) {
                // empty catch block
            }
        }
        try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
            prop.setProperty(PLAYER_ONLY_KEY, String.valueOf(state));
            prop.store(output, "KissMod Configuration");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

