/*
 * Decompiled with CFR 0.152.
 */
package com.awa.kissmod.packet;

import com.awa.kissmod.KissMod;
import com.awa.kissmod.packet.KissS2CPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class KissC2SPacket {
    private final UUID kissedEntityUuid;
    private final UUID senderUuid;
    private final String senderName;
    private final String targetName;
    private final String kissMessageFormat;
    private final String responseMessageFormat;
    private final boolean senderDoNotDisturb;

    public KissC2SPacket(UUID kissedEntityUuid, UUID senderUuid, String senderName, String targetName, String kissMessageFormat, String responseMessageFormat, boolean senderDoNotDisturb) {
        this.kissedEntityUuid = kissedEntityUuid;
        this.senderUuid = senderUuid;
        this.senderName = senderName;
        this.targetName = targetName;
        this.kissMessageFormat = kissMessageFormat;
        this.responseMessageFormat = responseMessageFormat;
        this.senderDoNotDisturb = senderDoNotDisturb;
    }

    public static void encode(KissC2SPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.kissedEntityUuid);
        buffer.m_130077_(packet.senderUuid);
        buffer.m_130070_(packet.senderName);
        buffer.m_130070_(packet.targetName);
        buffer.m_130070_(packet.kissMessageFormat);
        buffer.m_130070_(packet.responseMessageFormat);
        buffer.writeBoolean(packet.senderDoNotDisturb);
    }

    public static KissC2SPacket decode(FriendlyByteBuf buffer) {
        UUID kissedEntityUuid = buffer.m_130259_();
        UUID senderUuid = buffer.m_130259_();
        String senderName = buffer.m_130136_(Short.MAX_VALUE);
        String targetName = buffer.m_130136_(Short.MAX_VALUE);
        String kissMessageFormat = buffer.m_130136_(Short.MAX_VALUE);
        String responseMessageFormat = buffer.m_130136_(Short.MAX_VALUE);
        boolean senderDoNotDisturb = buffer.readBoolean();
        return new KissC2SPacket(kissedEntityUuid, senderUuid, senderName, targetName, kissMessageFormat, responseMessageFormat, senderDoNotDisturb);
    }

    public static void handle(KissC2SPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                UUID targetUuid = packet.getKissedEntityUuid();
                UUID senderUuid = packet.getSenderUuid();
                ServerLevel world = player.m_284548_();
                Entity target = world.m_8791_(targetUuid);
                if (target != null) {
                    KissS2CPacket broadcastPacket = new KissS2CPacket(target.m_20148_(), senderUuid, packet.senderName, packet.targetName, packet.kissMessageFormat, packet.responseMessageFormat, packet.senderDoNotDisturb);
                    for (ServerPlayer nearbyPlayer : world.m_6907_()) {
                        if (nearbyPlayer.m_20148_().equals(senderUuid)) continue;
                        KissMod.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> nearbyPlayer), (Object)broadcastPacket);
                    }
                    KissMod.setPlayerDoNotDisturb(senderUuid, packet.senderDoNotDisturb);
                    boolean targetDoNotDisturb = false;
                    if (target instanceof ServerPlayer) {
                        targetDoNotDisturb = KissMod.getPlayerDoNotDisturb(target.m_20148_());
                    }
                    if (!packet.senderDoNotDisturb) {
                        String message = String.format(packet.kissMessageFormat, packet.senderName, packet.targetName);
                        world.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)message), false);
                        if (target instanceof Player && !targetDoNotDisturb) {
                            String responseMessage = String.format(packet.responseMessageFormat, packet.targetName);
                            world.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)responseMessage), false);
                        } else if (target instanceof ServerPlayer && targetDoNotDisturb) {
                            String dndMessage = String.format("%s\u5f00\u542f\u4e86\u514d\u6253\u6270", packet.targetName);
                            player.m_213846_((Component)Component.m_237113_((String)dndMessage));
                        }
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }

    public UUID getKissedEntityUuid() {
        return this.kissedEntityUuid;
    }

    public UUID getSenderUuid() {
        return this.senderUuid;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getKissMessageFormat() {
        return this.kissMessageFormat;
    }

    public String getResponseMessageFormat() {
        return this.responseMessageFormat;
    }

    public boolean isSenderDoNotDisturb() {
        return this.senderDoNotDisturb;
    }
}

