/*
 * Decompiled with CFR 0.152.
 */
package com.miguel.economy.auction;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.miguel.economy.auction.AuctionListing;
import com.miguel.economy.auction.AuctionMenu;
import com.miguel.economy.economy.EconomyProvider;
import com.miguel.economy.economy.IEconomy;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;

public class AuctionHouse {
    private static final List<AuctionListing> LISTINGS = new ArrayList<AuctionListing>();
    private static final AtomicLong NEXT_ID = new AtomicLong(1L);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path storagePath;
    private static boolean locked;

    public static void init() {
    }

    public static boolean isLocked() {
        return locked;
    }

    public static void setLocked(boolean locked) {
        AuctionHouse.locked = locked;
        AuctionHouse.save();
    }

    public static void setStorageFolder(Path worldFolder) {
        storagePath = worldFolder.resolve("migueleconomy_auctions.json");
    }

    public static synchronized void load() {
        if (storagePath == null || !Files.exists(storagePath, new LinkOption[0])) {
            return;
        }
        try {
            String json = Files.readString(storagePath);
            try {
                SavedData savedData = (SavedData)GSON.fromJson(json, SavedData.class);
                if (savedData != null) {
                    LISTINGS.clear();
                    locked = savedData.locked;
                    long maxId = 0L;
                    if (savedData.listings != null) {
                        for (SavedListing s : savedData.listings) {
                            Optional itemOpt = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(s.itemId));
                            if (itemOpt.isEmpty()) continue;
                            ItemStack stack = new ItemStack((ItemLike)itemOpt.get());
                            if (s.count > 1) {
                                stack.m_41764_(s.count);
                            }
                            AuctionListing l = new AuctionListing(s.id, s.ownerUuid == null ? null : UUID.fromString(s.ownerUuid), s.ownerName, stack, s.price);
                            LISTINGS.add(l);
                            if (s.id <= maxId) continue;
                            maxId = s.id;
                        }
                    }
                    NEXT_ID.set(Math.max(1L, maxId + 1L));
                    return;
                }
            }
            catch (Exception savedData) {
                // empty catch block
            }
            Type type = new TypeToken<List<SavedListing>>(){}.getType();
            List saved = (List)GSON.fromJson(json, type);
            LISTINGS.clear();
            locked = false;
            long maxId = 0L;
            if (saved != null) {
                for (SavedListing s : saved) {
                    Optional itemOpt = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(s.itemId));
                    if (itemOpt.isEmpty()) continue;
                    ItemStack stack = new ItemStack((ItemLike)itemOpt.get());
                    if (s.count > 1) {
                        stack.m_41764_(s.count);
                    }
                    AuctionListing l = new AuctionListing(s.id, s.ownerUuid == null ? null : UUID.fromString(s.ownerUuid), s.ownerName, stack, s.price);
                    LISTINGS.add(l);
                    if (s.id <= maxId) continue;
                    maxId = s.id;
                }
            }
            NEXT_ID.set(Math.max(1L, maxId + 1L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void save() {
        if (storagePath == null) {
            return;
        }
        try {
            ArrayList<SavedListing> listings = new ArrayList<SavedListing>();
            for (AuctionListing l : LISTINGS) {
                String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)l.stack.m_41720_()).toString();
                listings.add(new SavedListing(l.id, itemId, l.stack.m_41613_(), l.price, l.seller == null ? null : l.seller.toString(), l.sellerName));
            }
            SavedData data = new SavedData();
            data.listings = listings;
            data.locked = locked;
            Files.createDirectories(storagePath.getParent(), new FileAttribute[0]);
            Files.writeString(storagePath, (CharSequence)GSON.toJson((Object)data), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized List<AuctionListing> getListings() {
        return new ArrayList<AuctionListing>(LISTINGS);
    }

    public static synchronized AuctionListing addListing(ServerPlayer seller, ItemStack stack, long price) {
        long id = NEXT_ID.getAndIncrement();
        AuctionListing listing = new AuctionListing(id, seller.m_20148_(), seller.m_36316_().getName(), stack, price);
        LISTINGS.add(listing);
        AuctionHouse.save();
        return listing;
    }

    public static synchronized Optional<AuctionListing> getByIndex(int idx) {
        if (idx < 0 || idx >= LISTINGS.size()) {
            return Optional.empty();
        }
        return Optional.of(LISTINGS.get(idx));
    }

    public static synchronized boolean removeListing(long id) {
        boolean res = LISTINGS.removeIf(l -> l.id == id);
        if (res) {
            AuctionHouse.save();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean purchase(ServerPlayer buyer, AuctionListing listing) {
        Class<AuctionHouse> clazz = AuctionHouse.class;
        synchronized (AuctionHouse.class) {
            ItemStack copy;
            ServerPlayer seller;
            if (!LISTINGS.contains(listing)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            LazyOptional buyerCapOpt = buyer.getCapability(EconomyProvider.ECON_CAP);
            if (!buyerCapOpt.isPresent()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            IEconomy buyerCap = (IEconomy)buyerCapOpt.orElse(null);
            if (buyerCap == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            if (!buyerCap.withdraw(listing.price)) {
                buyer.m_213846_((Component)Component.m_237113_((String)"Not enough balance.").m_130940_(ChatFormatting.RED));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            MinecraftServer server = buyer.f_8924_;
            ServerPlayer serverPlayer = seller = listing.seller == null ? null : server.m_6846_().m_11259_(listing.seller);
            if (seller != null) {
                seller.getCapability(EconomyProvider.ECON_CAP).ifPresent(cap -> cap.deposit(listing.price));
                seller.m_213846_((Component)Component.m_237113_((String)("Your item sold for " + listing.price + ".")));
            }
            if (!buyer.m_36356_(copy = listing.stack.m_41777_())) {
                buyer.m_36176_(copy, false);
            }
            LISTINGS.remove(listing);
            AuctionHouse.save();
            buyer.m_213846_((Component)Component.m_237113_((String)"Purchased ").m_7220_((Component)listing.stack.m_41786_().m_6881_().m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)" for ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("$" + listing.price)).m_130940_(ChatFormatting.GOLD)));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    public static MenuProvider createMenuProvider(Player viewer) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Auction House");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
                return new AuctionMenu(id, inv);
            }
        };
    }

    static {
        locked = false;
    }

    private static class SavedData {
        List<SavedListing> listings = new ArrayList<SavedListing>();
        boolean locked = false;

        private SavedData() {
        }
    }

    private static class SavedListing {
        long id;
        @SerializedName(value="item_ID")
        String itemId;
        int count;
        @SerializedName(value="item_price")
        long price;
        @SerializedName(value="owner_uuid")
        String ownerUuid;
        @SerializedName(value="item_owner")
        String ownerName;

        SavedListing(long id, String itemId, int count, long price, String ownerUuid, String ownerName) {
            this.id = id;
            this.itemId = itemId;
            this.count = count;
            this.price = price;
            this.ownerUuid = ownerUuid;
            this.ownerName = ownerName;
        }
    }
}

