/*
 * Decompiled with CFR 0.152.
 */
package com.miguel.economy.items;

import com.miguel.economy.economy.EconomyProvider;
import com.miguel.economy.items.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MoneyItem
extends Item {
    private static final String MONEY_VALUE_TAG = "MoneyValue";

    public MoneyItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        long value;
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && (value = MoneyItem.getMoneyValue(stack)) > 0L) {
            player.getCapability(EconomyProvider.ECON_CAP).ifPresent(economy -> {
                economy.deposit(value);
                player.m_213846_((Component)Component.m_237113_((String)("You received $" + value)).m_130940_(ChatFormatting.GREEN));
            });
            stack.m_41774_(1);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        long value = MoneyItem.getMoneyValue(stack);
        if (value > 0L) {
            tooltip.add((Component)Component.m_237113_((String)("Value: $" + value)).m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)Component.m_237113_((String)"Right-click to redeem").m_130940_(ChatFormatting.GRAY));
        }
    }

    public static long getMoneyValue(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(MONEY_VALUE_TAG)) {
            return tag.m_128454_(MONEY_VALUE_TAG);
        }
        return 0L;
    }

    public static void setMoneyValue(ItemStack stack, long value) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(MONEY_VALUE_TAG, value);
    }

    public static ItemStack createMoneyItem(long value) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.MONEY_ITEM.get());
        MoneyItem.setMoneyValue(stack, value);
        return stack;
    }
}

