/*
 * Decompiled with CFR 0.152.
 */
package com.miguel.economy.shop;

import com.miguel.economy.MiguelEconomy;
import com.miguel.economy.economy.EconomyProvider;
import com.miguel.economy.shop.ShopManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.NetworkHooks;

public class ShopMenu
extends AbstractContainerMenu {
    private final Container container;
    private final Mode mode;
    private final String categoryName;

    public ShopMenu(int id, Inventory inv) {
        super((MenuType)MiguelEconomy.SHOP_MENU.get(), id);
        this.mode = Mode.CATEGORIES;
        this.categoryName = null;
        this.container = new SimpleContainer(54){

            public boolean m_6542_(Player p) {
                return true;
            }
        };
        this.populateCategories(inv.f_35978_);
        this.layout(inv);
    }

    public ShopMenu(int id, Inventory inv, String categoryName) {
        super((MenuType)MiguelEconomy.SHOP_MENU.get(), id);
        this.mode = Mode.ITEMS;
        this.categoryName = categoryName;
        this.container = new SimpleContainer(54){

            public boolean m_6542_(Player p) {
                return true;
            }
        };
        this.populateItems(inv.f_35978_, categoryName);
        this.layout(inv);
    }

    public static IContainerFactory<ShopMenu> factory() {
        return (id, inv, buf) -> {
            if (buf == null) {
                return new ShopMenu(id, inv);
            }
            boolean isItems = buf.readBoolean();
            if (isItems) {
                String cat = buf.m_130136_(64);
                return new ShopMenu(id, inv, cat);
            }
            return new ShopMenu(id, inv);
        };
    }

    private void populateCategories(Player viewer) {
        List<ShopManager.Category> cats = ShopManager.getCategories();
        for (int i = 0; i < Math.min(54, cats.size()); ++i) {
            ShopManager.Category c = cats.get(i);
            ItemStack icon = c.icon().m_41777_();
            icon.m_41714_((Component)Component.m_237113_((String)c.name()).m_130940_(ChatFormatting.AQUA));
            ListTag lore = new ListTag();
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Click to open").m_130940_(ChatFormatting.GREEN))));
            CompoundTag d = icon.m_41698_("display");
            d.m_128365_("Lore", (Tag)lore);
            this.container.m_6836_(i, icon);
        }
    }

    private void populateItems(Player viewer, String category) {
        List<ShopManager.ShopItem> items = ShopManager.getItems(category);
        int maxItems = Math.min(53, items.size());
        for (int i = 0; i < maxItems; ++i) {
            ShopManager.ShopItem it = items.get(i);
            ItemStack icon = new ItemStack((ItemLike)it.item());
            icon.m_41714_((Component)icon.m_41786_().m_6881_().m_130940_(ChatFormatting.AQUA));
            ListTag lore = new ListTag();
            if (it.canBuy()) {
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)("BUY for $" + it.buyPrice())).m_130940_(ChatFormatting.GREEN))));
            } else {
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Cannot be bought").m_130940_(ChatFormatting.RED))));
            }
            if (it.canSell()) {
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)("SELL for $" + it.sellPrice())).m_130940_(ChatFormatting.GOLD))));
            } else {
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Cannot be sold").m_130940_(ChatFormatting.RED))));
            }
            CompoundTag d = icon.m_41698_("display");
            d.m_128365_("Lore", (Tag)lore);
            this.container.m_6836_(i, icon);
        }
        ItemStack back = new ItemStack((ItemLike)Items.f_42153_);
        back.m_41714_((Component)Component.m_237113_((String)"Back to Categories").m_130940_(ChatFormatting.RED));
        ListTag bl = new ListTag();
        bl.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Click to go back").m_130940_(ChatFormatting.GRAY))));
        back.m_41698_("display").m_128365_("Lore", (Tag)bl);
        this.container.m_6836_(53, back);
    }

    private void layout(Inventory playerInv) {
        int col;
        int row;
        for (row = 0; row < 6; ++row) {
            for (col = 0; col < 9; ++col) {
                int slot = col + row * 9;
                int x = 8 + col * 18;
                int y = 18 + row * 18;
                this.m_38897_(new Slot(this.container, slot, x, y){

                    public boolean m_5857_(ItemStack stack) {
                        return false;
                    }

                    public boolean m_8010_(Player player) {
                        return false;
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.m_38897_(new Slot((Container)playerInv, col2, 8 + col2 * 18, 198));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
        if (!(player instanceof ServerPlayer)) {
            super.m_150399_(slotId, button, clickType, player);
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (slotId >= 0 && slotId < 54 && clickType == ClickType.PICKUP) {
            if (this.mode == Mode.CATEGORIES) {
                List<ShopManager.Category> cats;
                if (button == 0 && slotId < (cats = ShopManager.getCategories()).size()) {
                    final ShopManager.Category c = cats.get(slotId);
                    NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)new MenuProvider(){

                        public Component m_5446_() {
                            return Component.m_237113_((String)c.name());
                        }

                        public AbstractContainerMenu m_7208_(int id, Inventory inv, Player p) {
                            return new ShopMenu(id, inv, c.name());
                        }
                    }, buf -> {
                        buf.writeBoolean(true);
                        buf.m_130072_(c.name(), 64);
                    });
                }
                return;
            }
            if (slotId == 53 && button == 0) {
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237113_((String)"Shop");
                    }

                    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player p) {
                        return new ShopMenu(id, inv);
                    }
                }, buf -> buf.writeBoolean(false));
                return;
            }
            List<ShopManager.ShopItem> items = ShopManager.getItems(this.categoryName);
            if (slotId < items.size()) {
                ShopManager.ShopItem it = items.get(slotId);
                if (button == 0) {
                    if (it.canBuy()) {
                        sp.getCapability(EconomyProvider.ECON_CAP).ifPresent(cap -> {
                            if (cap.withdraw(it.buyPrice())) {
                                ItemStack give = new ItemStack((ItemLike)it.item());
                                if (!sp.m_36356_(give)) {
                                    sp.m_36176_(give, false);
                                }
                                sp.m_213846_((Component)Component.m_237113_((String)"Purchased ").m_7220_((Component)give.m_41786_().m_6881_().m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)" for $").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)String.valueOf(it.buyPrice())).m_130940_(ChatFormatting.GOLD)));
                            } else {
                                sp.m_213846_((Component)Component.m_237113_((String)"Not enough balance.").m_130940_(ChatFormatting.RED));
                            }
                        });
                    } else {
                        sp.m_213846_((Component)Component.m_237113_((String)"This item cannot be bought.").m_130940_(ChatFormatting.RED));
                    }
                } else if (button == 1) {
                    if (it.canSell()) {
                        int slot = this.findItem(sp, it.item());
                        if (slot >= 0) {
                            ItemStack in = sp.m_150109_().m_8020_(slot);
                            in.m_41774_(1);
                            sp.getCapability(EconomyProvider.ECON_CAP).ifPresent(cap -> cap.deposit(it.sellPrice()));
                            sp.m_213846_((Component)Component.m_237113_((String)"Sold 1x ").m_7220_((Component)new ItemStack((ItemLike)it.item()).m_41786_().m_6881_().m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)" for $").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)String.valueOf(it.sellPrice())).m_130940_(ChatFormatting.GOLD)));
                        } else {
                            sp.m_213846_((Component)Component.m_237113_((String)"You don't have this item to sell.").m_130940_(ChatFormatting.RED));
                        }
                    } else {
                        sp.m_213846_((Component)Component.m_237113_((String)"This item cannot be sold.").m_130940_(ChatFormatting.RED));
                    }
                }
            }
            return;
        }
        super.m_150399_(slotId, button, clickType, player);
    }

    private int findItem(ServerPlayer sp, Item target) {
        for (int i = 0; i < sp.m_150109_().f_35974_.size(); ++i) {
            ItemStack s = (ItemStack)sp.m_150109_().f_35974_.get(i);
            if (s.m_41619_() || s.m_41720_() != target) continue;
            return i;
        }
        return -1;
    }

    public static enum Mode {
        CATEGORIES,
        ITEMS;

    }
}

