/*
 * Decompiled with CFR 0.152.
 */
package com.miguel.economy;

import com.miguel.economy.auction.AuctionHouse;
import com.miguel.economy.auction.AuctionMenu;
import com.miguel.economy.auction.AuctionScreen;
import com.miguel.economy.commands.AuctionCommands;
import com.miguel.economy.commands.BalanceCommand;
import com.miguel.economy.commands.BaltopCommand;
import com.miguel.economy.commands.MoneyCommands;
import com.miguel.economy.commands.PayCommand;
import com.miguel.economy.commands.ShopCommand;
import com.miguel.economy.economy.EconomyEvents;
import com.miguel.economy.items.ModCreativeModeTabs;
import com.miguel.economy.items.ModItems;
import com.miguel.economy.shop.ShopManager;
import com.miguel.economy.shop.ShopMenu;
import com.miguel.economy.shop.ShopScreen;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="migueleconomy")
public class MiguelEconomy {
    public static final String MODID = "migueleconomy";
    private static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"migueleconomy");
    public static final RegistryObject<MenuType<AuctionMenu>> AUCTION_MENU = MENUS.register("auction_menu", () -> IForgeMenuType.create((id, inv, buf) -> new AuctionMenu(id, inv)));
    public static final RegistryObject<MenuType<ShopMenu>> SHOP_MENU = MENUS.register("shop_menu", () -> IForgeMenuType.create(ShopMenu.factory()));

    public MiguelEconomy() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        MENUS.register(modBus);
        ModItems.register(modBus);
        ModCreativeModeTabs.register(modBus);
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::clientSetup);
        modBus.addListener(EconomyEvents::onRegisterCapabilities);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopping);
        EconomyEvents.register();
    }

    private void commonSetup(FMLCommonSetupEvent e) {
        AuctionHouse.init();
    }

    private void clientSetup(FMLClientSetupEvent e) {
        e.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)AUCTION_MENU.get()), AuctionScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SHOP_MENU.get()), ShopScreen::new);
        });
    }

    private void registerCommands(RegisterCommandsEvent e) {
        BalanceCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        PayCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        BaltopCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        AuctionCommands.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        ShopCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        MoneyCommands.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static void openAuction(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        MenuProvider provider = AuctionHouse.createMenuProvider(player);
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, buf -> {});
    }

    private void onServerStarting(ServerStartingEvent e) {
        Path worldFolder = e.getServer().m_129843_(LevelResource.f_78182_);
        AuctionHouse.setStorageFolder(worldFolder);
        AuctionHouse.load();
        ShopManager.load();
    }

    private void onServerStopping(ServerStoppingEvent e) {
        AuctionHouse.save();
    }
}

