/*
 * Decompiled with CFR 0.152.
 */
package com.miguel.economy.shop;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLPaths;

public class ShopManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<Category> CATEGORIES = new ArrayList<Category>();
    private static boolean locked = false;

    public static Path getShopDir() {
        return FMLPaths.CONFIGDIR.get().resolve("migueleconomy").resolve("shop");
    }

    public static boolean isLocked() {
        return locked;
    }

    public static void setLocked(boolean locked) {
        ShopManager.locked = locked;
        ShopManager.saveSettings();
    }

    private static void saveSettings() {
        Path settingsFile = ShopManager.getShopDir().resolve("settings.json");
        try {
            Files.createDirectories(settingsFile.getParent(), new FileAttribute[0]);
            ShopSettings settings = new ShopSettings();
            settings.locked = locked;
            Files.writeString(settingsFile, (CharSequence)GSON.toJson((Object)settings), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        CATEGORIES.clear();
        Path dir = ShopManager.getShopDir();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path settingsFile = dir.resolve("settings.json");
            if (Files.exists(settingsFile, new LinkOption[0])) {
                try {
                    String json = Files.readString(settingsFile, StandardCharsets.UTF_8);
                    ShopSettings settings = (ShopSettings)GSON.fromJson(json, ShopSettings.class);
                    if (settings != null) {
                        locked = settings.locked;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            boolean hasExistingShops = false;
            try (Stream<Path> stream = Files.list(dir);){
                hasExistingShops = stream.filter(p -> p.toString().endsWith(".json") && !p.getFileName().toString().equals("settings.json")).findAny().isPresent();
            }
            if (!hasExistingShops) {
                ShopManager.loadDefaultShops(dir);
            }
            try (Stream<Path> files = Files.list(dir);){
                files.filter(p -> p.toString().endsWith(".json") && !p.getFileName().toString().equals("settings.json")).forEach(ShopManager::loadFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadDefaultShops(Path dir) {
        String[] defaultShopFiles;
        for (String fileName : defaultShopFiles = new String[]{"weapons.json", "armor.json", "tools.json", "food.json", "building.json", "aether.json", "bumblezone.json", "create.json", "deep_aether.json", "undergarden.json"}) {
            try (InputStream inputStream = ShopManager.class.getResourceAsStream("/assets/migueleconomy/shop/default/" + fileName);){
                if (inputStream == null) continue;
                Path targetFile = dir.resolve(fileName);
                try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                    int bytesRead;
                    StringBuilder content = new StringBuilder();
                    char[] buffer = new char[1024];
                    while ((bytesRead = reader.read(buffer)) != -1) {
                        content.append(buffer, 0, bytesRead);
                    }
                    Files.writeString(targetFile, (CharSequence)content.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadFile(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            CategoryJson json = (CategoryJson)GSON.fromJson((Reader)reader, CategoryJson.class);
            if (json == null || json.categoryName == null || json.categoryItem == null || json.items == null) {
                return;
            }
            ResourceLocation catItemId = ShopManager.normalize(json.categoryItem);
            Optional catItem = BuiltInRegistries.f_257033_.m_6612_(catItemId);
            if (catItem.isEmpty()) {
                return;
            }
            ArrayList<ShopItem> entries = new ArrayList<ShopItem>();
            for (ItemJson ij : json.items) {
                ResourceLocation itemId;
                Optional it;
                if (ij == null || ij.id == null || (it = BuiltInRegistries.f_257033_.m_6612_(itemId = ShopManager.normalize(ij.id))).isEmpty()) continue;
                long buy = Math.max(0L, ij.buyPrice);
                long sell = Math.max(0L, ij.sellPrice);
                entries.add(new ShopItem((Item)it.get(), buy, sell, ij.canBuy, ij.canSell));
            }
            if (!entries.isEmpty()) {
                CATEGORIES.add(new Category(json.categoryName, new ItemStack((ItemLike)catItem.get()), entries));
            }
        }
        catch (JsonParseException | IOException e) {
            e.printStackTrace();
        }
    }

    private static ResourceLocation normalize(String id) {
        if (id.contains(":")) {
            return new ResourceLocation(id);
        }
        return new ResourceLocation("minecraft", id);
    }

    public static List<Category> getCategories() {
        return new ArrayList<Category>(CATEGORIES);
    }

    public static List<ShopItem> getItems(String categoryName) {
        for (Category c : CATEGORIES) {
            if (!c.name.equalsIgnoreCase(categoryName)) continue;
            return new ArrayList<ShopItem>(c.items);
        }
        return Collections.emptyList();
    }

    private static class ShopSettings {
        boolean locked = false;

        private ShopSettings() {
        }
    }

    private static class CategoryJson {
        @SerializedName(value="category_name")
        String categoryName;
        @SerializedName(value="category_item")
        String categoryItem;
        List<ItemJson> items;

        private CategoryJson() {
        }
    }

    private static class ItemJson {
        String id;
        @SerializedName(value="buy_price")
        long buyPrice;
        @SerializedName(value="sell_price")
        long sellPrice;
        @SerializedName(value="can_buy")
        boolean canBuy;
        @SerializedName(value="can_sell")
        boolean canSell;

        private ItemJson() {
        }
    }

    public record ShopItem(Item item, long buyPrice, long sellPrice, boolean canBuy, boolean canSell) {
    }

    public record Category(String name, ItemStack icon, List<ShopItem> items) {
    }
}

