/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.env.ctx;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.util.MethodQualifier;
import org.sinytra.adapter.patch.util.provider.ClassLookup;
import org.slf4j.Logger;

public class MethodFinder {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private final String fallbackOwner;

    public MethodFinder(String fallbackOwner) {
        this.fallbackOwner = fallbackOwner;
    }

    @Nullable
    public MethodContext.TargetPair findMethod(ClassLookup lookup, MethodQualifier qualifier, int flags) {
        Pair<ClassNode, List<MethodNode>> pair = this.findMethods(lookup, qualifier, flags);
        if (pair == null) {
            return null;
        }
        if (((List)pair.getSecond()).isEmpty()) {
            LOGGER.debug("Target method not found: {}{}{}", new Object[]{qualifier.owner(), qualifier.name(), qualifier.desc()});
            return null;
        }
        if (((List)pair.getSecond()).size() > 1) {
            LOGGER.debug("Multiple candidates found for method: {}{}{}", new Object[]{qualifier.owner(), qualifier.name(), qualifier.desc()});
            return null;
        }
        return new MethodContext.TargetPair((ClassNode)pair.getFirst(), (MethodNode)((List)pair.getSecond()).getFirst());
    }

    @Nullable
    public Pair<ClassNode, List<MethodNode>> findMethods(ClassLookup lookup, MethodQualifier qualifier, int flags) {
        String owner;
        if (qualifier == null || qualifier.name() == null) {
            return null;
        }
        if (qualifier.internalOwnerName() != null) {
            owner = qualifier.internalOwnerName();
        } else if (MethodFinder.hasFlag(flags, 2) && this.fallbackOwner != null) {
            owner = this.fallbackOwner;
        } else {
            return null;
        }
        ClassNode targetClass = lookup.getClass(owner).orElse(null);
        if (targetClass == null) {
            return null;
        }
        String desc = qualifier.desc();
        List<MethodNode> candidates = targetClass.methods.stream().filter(mtd -> mtd.name.equals(qualifier.name()) && (MethodFinder.hasFlag(flags, 1) || desc == null || mtd.desc.equals(desc))).toList();
        if (candidates.size() > 1 && desc == null) {
            candidates = candidates.stream().filter(mtd -> (mtd.access & 0x1000) == 0 && (mtd.access & 0x40) == 0).toList();
        }
        if (candidates.isEmpty() && targetClass.superName != null) {
            return this.findMethods(lookup, new MethodQualifier(Type.getObjectType((String)targetClass.superName).getDescriptor(), qualifier.name(), qualifier.desc()), flags);
        }
        return Pair.of((Object)targetClass, candidates);
    }

    private static boolean hasFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static class Flags {
        public static final int IGNORE_DESC = 1;
        public static final int FALLBACK_OWNER = 2;
    }
}

