/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation.param;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformationUtil;
import org.sinytra.adapter.patch.transformer.operation.param.ParameterTransformer;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.SingleValueHandle;
import org.slf4j.Logger;

public record SwapParametersTransformer(int from, int to) implements ParameterTransformer
{
    private static final Logger LOGGER = LogUtils.getLogger();
    static final Codec<SwapParametersTransformer> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.intRange((int)0, (int)255).fieldOf("from").forGetter(SwapParametersTransformer::from), (App)Codec.intRange((int)0, (int)255).fieldOf("to").forGetter(SwapParametersTransformer::to)).apply((Applicative)in, SwapParametersTransformer::new));

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context, List<Type> parameters, int offset) {
        int from = offset + this.from;
        int to = offset + this.to;
        boolean nonStatic = !methodContext.isStatic();
        ParameterNode fromNode = (ParameterNode)methodNode.parameters.get(from);
        ParameterNode toNode = (ParameterNode)methodNode.parameters.get(to);
        int fromOldLVT = ParamTransformationUtil.calculateLVTIndex(parameters, nonStatic, from);
        int toOldLVT = ParamTransformationUtil.calculateLVTIndex(parameters, nonStatic, to);
        Type fromType = parameters.get(from);
        Type toType = parameters.get(to);
        parameters.set(from, toType);
        parameters.set(to, fromType);
        methodNode.parameters.set(from, toNode);
        methodNode.parameters.set(to, fromNode);
        LOGGER.info(PatchInstance.MIXINPATCH, "Swapped parameters at positions {}({}) and {}({}) in {}.{}", new Object[]{from, fromNode.name, to, toNode.name, classNode.name, methodNode.name});
        int fromNewLVT = ParamTransformationUtil.calculateLVTIndex(parameters, nonStatic, from);
        int toNewLVT = ParamTransformationUtil.calculateLVTIndex(parameters, nonStatic, to);
        SwapParametersTransformer.swapLVT(methodNode, fromOldLVT, toNewLVT).andThen(SwapParametersTransformer.swapLVT(methodNode, toOldLVT, fromNewLVT)).accept(null);
        return Patch.Result.COMPUTE_FRAMES;
    }

    @Override
    public Codec<? extends ParameterTransformer> codec() {
        return CODEC;
    }

    public static Consumer<Void> swapLVT(MethodNode methodNode, int from, int to) {
        Consumer<Void> r = v -> {};
        for (LocalVariableNode lvn : methodNode.localVariables) {
            if (lvn.index != from) continue;
            r = r.andThen(v -> {
                lvn.index = to;
            });
        }
        for (AbstractInsnNode insn : methodNode.instructions) {
            SingleValueHandle<Integer> handle = AdapterUtil.handleLocalVarInsnValue(insn);
            if (handle == null || handle.get() != from) continue;
            LOGGER.info("Swapping in LVT: {} to {}", (Object)from, (Object)to);
            r = r.andThen(v -> handle.set(to));
        }
        return r;
    }
}

