/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.util;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import org.sinytra.adapter.patch.analysis.locals.LocalVariableLookup;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.adapter.patch.util.SingleValueHandle;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.gen.AccessorInfo;

public final class AdapterUtil {
    public static final Codec<Type> TYPE_CODEC = Codec.STRING.xmap(Type::getType, Type::getDescriptor);
    public static final String LAMBDA_PREFIX = "lambda$";
    private static final Pattern FIELD_REF_PATTERN = Pattern.compile("^(?<owner>L.+?;)?(?<name>[^:]+)?:(?<desc>.+)?$");
    public static final Type CI_TYPE = Type.getObjectType((String)"org/spongepowered/asm/mixin/injection/callback/CallbackInfo");
    public static final Type CIR_TYPE = Type.getObjectType((String)"org/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable");
    public static final Type OPERATION_TYPE = Type.getObjectType((String)"com/llamalad7/mixinextras/injector/wrapoperation/Operation");
    private static final Logger LOGGER = LogUtils.getLogger();

    public static int getLVTOffsetForType(Type type) {
        return type.equals((Object)Type.DOUBLE_TYPE) || type.equals((Object)Type.LONG_TYPE) ? 2 : 1;
    }

    public static int getLVTIndexForParam(MethodNode method, int paramIndex, Type type) {
        Type[] paramTypes = Type.getArgumentTypes((String)method.desc);
        int ordinal = 0;
        for (int i = paramIndex - 1; i > 0; --i) {
            if (!type.equals((Object)paramTypes[i])) continue;
            ++ordinal;
        }
        List<LocalVariableNode> locals = method.localVariables.stream().sorted(Comparator.comparingInt(lvn -> lvn.index)).filter(lvn -> lvn.desc.equals(type.getDescriptor())).toList();
        if (locals.size() > ordinal) {
            return locals.get((int)ordinal).index;
        }
        return -1;
    }

    public static String randomString(int length) {
        int leftLimit = 48;
        int rightLimit = 122;
        Random random = new Random();
        return random.ints(leftLimit, rightLimit + 1).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static boolean isAnonymousClass(String name) {
        return name.matches("^.+\\$\\d+$");
    }

    public static Optional<String> getAccessorTargetFieldName(String owner, MethodNode method, AnnotationHandle annotationHandle, PatchEnvironment environment) {
        return annotationHandle.getValue("value").map(AnnotationValueHandle::get).filter(str -> !str.isEmpty()).or(() -> Optional.ofNullable(AccessorInfo.AccessorName.of((String)method.name)).map(name -> environment.refmapHolder().remap(owner, name.name)));
    }

    public static String maybeRemapFieldRef(String reference) {
        Matcher matcher = FIELD_REF_PATTERN.matcher(reference);
        if (matcher.matches()) {
            String name = matcher.group("name");
            String desc = matcher.group("desc");
            if (name != null && desc != null) {
                return Objects.requireNonNullElse(matcher.group("owner"), "") + name + ":" + desc;
            }
        }
        return reference;
    }

    @Nullable
    public static SingleValueHandle<Integer> handleLocalVarInsnValue(AbstractInsnNode insn) {
        if (insn instanceof VarInsnNode) {
            VarInsnNode varInsn = (VarInsnNode)insn;
            return SingleValueHandle.of(() -> varInsn.var, i -> {
                varInsn.var = i;
            });
        }
        if (insn instanceof IincInsnNode) {
            IincInsnNode iincInsn = (IincInsnNode)insn;
            return SingleValueHandle.of(() -> iincInsn.var, i -> {
                iincInsn.var = i;
            });
        }
        return null;
    }

    public static void replaceLVT(MethodNode methodNode, Int2IntFunction operator) {
        for (AbstractInsnNode insn : methodNode.instructions) {
            int oldValue;
            int newValue;
            SingleValueHandle<Integer> handle = AdapterUtil.handleLocalVarInsnValue(insn);
            if (handle == null || (newValue = operator.applyAsInt(oldValue = handle.get().intValue())) == oldValue) continue;
            handle.set(newValue);
        }
    }

    public static boolean canHandleLocalVarInsnValue(AbstractInsnNode insn) {
        return insn instanceof VarInsnNode || insn instanceof IincInsnNode;
    }

    public static int getInsnIntConstValue(AbstractInsnNode insn) {
        return AdapterUtil.getIntConstValue(insn).orElseThrow(() -> new IllegalArgumentException("Not an int constant opcode: " + insn.getOpcode()));
    }

    public static OptionalInt getIntConstValue(AbstractInsnNode insn) {
        int opcode = insn.getOpcode();
        if (opcode >= 3 && opcode <= 8) {
            return OptionalInt.of(opcode - 3);
        }
        if (opcode == 16 || opcode == 17) {
            return OptionalInt.of(((IntInsnNode)insn).operand);
        }
        return OptionalInt.empty();
    }

    public static AbstractInsnNode getIntConstInsn(int value) {
        if (value >= 1 && value <= 5) {
            return new InsnNode(3 + value);
        }
        if (value > 5 && value <= 127) {
            return new IntInsnNode(16, value);
        }
        return new LdcInsnNode((Object)value);
    }

    public static InsnList insnsWithAdapter(Consumer<InstructionAdapter> consumer) {
        MethodNode dummy = new MethodNode();
        InstructionAdapter adapter = new InstructionAdapter((MethodVisitor)dummy);
        consumer.accept(adapter);
        return dummy.instructions;
    }

    public static boolean isShadowField(FieldNode field) {
        return AdapterUtil.hasAnnotation(field.visibleAnnotations, "Lorg/spongepowered/asm/mixin/Shadow;");
    }

    public static boolean hasAnnotation(List<AnnotationNode> annotations, String desc) {
        return annotations != null && annotations.stream().anyMatch(an -> desc.equals(an.desc));
    }

    public static <T> List<T> summariseLocals(T[] locals, int pos) {
        ArrayList<T> list = new ArrayList<T>();
        if (locals != null) {
            for (int i = pos; i < locals.length; ++i) {
                if (locals[i] == null) continue;
                list.add(locals[i]);
            }
        }
        return list;
    }

    public static <T> List<T> getAnnotatedParameters(MethodNode methodNode, Type[] parameters, String annotationDesc, BiFunction<AnnotationNode, Type, T> processor) {
        ArrayList<T> list = new ArrayList<T>();
        if (methodNode.invisibleParameterAnnotations != null) {
            for (int i = 0; i < methodNode.invisibleParameterAnnotations.length; ++i) {
                List parameterAnnotations = methodNode.invisibleParameterAnnotations[i];
                if (parameterAnnotations == null) continue;
                for (AnnotationNode paramAnn : parameterAnnotations) {
                    if (!annotationDesc.equals(paramAnn.desc)) continue;
                    Type type = parameters[i];
                    list.add(processor.apply(paramAnn, type));
                }
            }
        }
        return list;
    }

    @Nullable
    public static CapturedLocals getCapturedLocals(MethodNode methodNode, MethodContext methodContext) {
        AnnotationHandle annotation = methodContext.methodAnnotation();
        Type[] params = Type.getArgumentTypes((String)methodNode.desc);
        OptionalInt paramLocalPos = AdapterUtil.getCapturedLocalStartingIndex(params);
        if (paramLocalPos.isEmpty()) {
            LOGGER.debug("Missing CI or CIR argument in injector of type {}", (Object)annotation.getDesc());
            return null;
        }
        MethodContext.TargetPair target = methodContext.findDirtyInjectionTarget();
        if (target == null) {
            return null;
        }
        List<Type> ignored = AdapterUtil.getAnnotatedParameters(methodNode, params, "Lcom/llamalad7/mixinextras/sugar/Share;", (node, type) -> type);
        Type[] availableParams = (Type[])Stream.of(params).filter(t -> !ignored.contains(t)).toArray(Type[]::new);
        boolean isStatic = (methodNode.access & 8) != 0;
        int lvtOffset = isStatic ? 0 : 1;
        int paramLocalPosVal = paramLocalPos.getAsInt();
        List<Type> expected = AdapterUtil.summariseLocals(availableParams, paramLocalPosVal);
        return new CapturedLocals(target, isStatic, paramLocalPosVal, paramLocalPosVal + expected.size(), lvtOffset, expected, new LocalVariableLookup(methodNode));
    }

    private static OptionalInt getCapturedLocalStartingIndex(Type[] params) {
        for (int i = 0; i < params.length; ++i) {
            Type param = params[i];
            if (!param.equals((Object)CI_TYPE) && !param.equals((Object)CIR_TYPE) || i + 1 >= params.length) continue;
            return OptionalInt.of(i + 1);
        }
        return OptionalInt.empty();
    }

    public static AbstractInsnNode iterateInsns(AbstractInsnNode insn, UnaryOperator<AbstractInsnNode> flow, Predicate<AbstractInsnNode> filter) {
        AbstractInsnNode i = (AbstractInsnNode)flow.apply(insn);
        while (i != null) {
            if (filter.test(i)) {
                return i;
            }
            i = (AbstractInsnNode)flow.apply(i);
        }
        return null;
    }

    public static <T> T[] removeArrayElement(T[] arr, int index, IntFunction<T[]> arrayGen) {
        if (arr == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(Arrays.asList(arr));
        list.remove(index);
        return list.toArray(arrayGen);
    }

    @VisibleForTesting
    public static String methodNodeToString(MethodNode node) {
        Textifier text = new Textifier();
        node.accept((MethodVisitor)new TraceMethodVisitor((Printer)text));
        return AdapterUtil.toString(text);
    }

    private static String toString(Textifier text) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        text.print(pw);
        pw.flush();
        return sw.toString();
    }

    public static InsnList insnList(AbstractInsnNode ... insns) {
        InsnList list = new InsnList();
        for (AbstractInsnNode node : insns) {
            list.add(node);
        }
        return list;
    }

    public static InsnList insnList(List<AbstractInsnNode> insns) {
        InsnList list = new InsnList();
        for (AbstractInsnNode node : insns) {
            list.add(node);
        }
        return list;
    }

    public static List<AbstractInsnNode> cloneInsns(Collection<AbstractInsnNode> insns) {
        return insns.stream().map(i -> i.clone(Map.of())).toList();
    }

    public static Type getMixinCallableReturnType(MethodNode method) {
        return Type.getReturnType((String)method.desc) == Type.VOID_TYPE ? CI_TYPE : CIR_TYPE;
    }

    public static <T> boolean allElementsEqual(Collection<T> list, BiPredicate<T, T> equalityFn) {
        return list.stream().reduce((a, b) -> equalityFn.test(a, b) ? a : null).map(x -> true).orElse(true);
    }

    private AdapterUtil() {
    }

    public record CapturedLocals(MethodContext.TargetPair target, boolean isStatic, int paramLocalStart, int paramLocalEnd, int lvtOffset, List<Type> expected, LocalVariableLookup lvt) {
    }
}

