/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator;

import com.electronwill.nightconfig.core.file.FileConfig;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.neoforged.fml.loading.ClasspathLocatorUtils;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.ModDirTransformerDiscoverer;
import net.neoforged.fml.loading.StringUtils;
import org.slf4j.Logger;

public final class FabricModsDiscoverer {
    private static final String SUFFIX = ".jar";
    private static final String ADDITIONAL_MODS_PROPERTY = "connector.additionalModLocations";
    private static final Logger LOGGER = LogUtils.getLogger();

    public static Stream<Path> scanFabricMods() {
        List excluded = ModDirTransformerDiscoverer.allExcluded();
        return Stream.of(FabricModsDiscoverer.scanModsDir(excluded), FabricModsDiscoverer.scanClasspath(), FabricModsDiscoverer.scanFromArguments(excluded)).flatMap(Function.identity());
    }

    private static Stream<Path> scanModsDir(List<Path> excluded) {
        return FabricModsDiscoverer.filterPaths((Stream)LambdaExceptionUtils.uncheck(() -> Files.list(FMLPaths.MODSDIR.get())), excluded);
    }

    private static Stream<Path> filterPaths(Stream<Path> stream, List<Path> excluded) {
        return stream.filter(p -> !excluded.contains(p) && StringUtils.toLowerCase((String)p.getFileName().toString()).endsWith(SUFFIX)).sorted(Comparator.comparing(path -> StringUtils.toLowerCase((String)path.getFileName().toString()))).filter(FabricModsDiscoverer::isFabricModJar);
    }

    private static Stream<Path> scanClasspath() {
        if (FMLEnvironment.production) {
            return Stream.of(new Path[0]);
        }
        try {
            ArrayList<Path> claimed = new ArrayList<Path>(Arrays.stream(System.getProperty("legacyClassPath", "").split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).toList());
            Stream.Builder<Path> ret = Stream.builder();
            Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources("fabric.mod.json");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Path path = ClasspathLocatorUtils.findJarPathFor((String)"fabric.mod.json", (String)"fabric.mod.json", (URL)url);
                if (!claimed.stream().noneMatch(path::equals) || !Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) || !FabricModsDiscoverer.isFabricModJar(path)) continue;
                ret.add(path);
            }
            return ret.build();
        }
        catch (IOException e) {
            LOGGER.error(LogMarkers.SCAN, "Error trying to find resources", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Stream<Path> scanFromArguments(List<Path> excluded) {
        String[] paths = System.getProperty(ADDITIONAL_MODS_PROPERTY, "").split(",");
        if (paths.length == 0) {
            return Stream.of(new Path[0]);
        }
        Stream.Builder files = Stream.builder();
        Arrays.stream(paths).filter(s -> !s.isBlank()).map(x$0 -> Path.of(x$0, new String[0])).forEach(path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                ((Stream)LambdaExceptionUtils.uncheck(() -> Files.list(path))).forEach(files::add);
            } else {
                files.add(path);
            }
        });
        return FabricModsDiscoverer.filterPaths(files.build(), excluded);
    }

    private static boolean isFabricModJar(Path path) {
        SecureJar secureJar = SecureJar.from((Path[])new Path[]{path});
        String name = secureJar.name();
        Path modsToml = secureJar.getPath("META-INF/neoforge.mods.toml", new String[0]);
        if (Files.exists(modsToml, new LinkOption[0]) && !FabricModsDiscoverer.containsPlaceholder(modsToml)) {
            LOGGER.debug(LogMarkers.SCAN, "Skipping jar {} as it contains a mods.toml file", (Object)path);
            return false;
        }
        if (secureJar.moduleDataProvider().findFile("fabric.mod.json").isPresent()) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod: {}", (Object)"fabric.mod.json", (Object)path);
            return true;
        }
        LOGGER.info(LogMarkers.SCAN, "Fabric mod metadata not found in jar {}, ignoring", (Object)name);
        return false;
    }

    private static boolean containsPlaceholder(Path modsTomlPath) {
        try {
            FileConfig fileConfig = FileConfig.of((Path)modsTomlPath);
            fileConfig.load();
            fileConfig.close();
            return fileConfig.getOptional("properties").map(map -> map.contains("connector:placeholder")).orElse(false);
        }
        catch (Throwable t) {
            LOGGER.error("Error reading placeholder information from {}", (Object)modsTomlPath, (Object)t);
            return false;
        }
    }
}

