/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.inventory;

import de.siphalor.mousewheelie.MouseWheelie;
import de.siphalor.mousewheelie.client.MWClient;
import de.siphalor.mousewheelie.client.network.MWClientNetworking;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class ToolPicker {
    @Generated
    private static final Logger log = MouseWheelie.createLogger(ToolPicker.class);
    private final class_1661 inventory;
    static int lastToolPickSlot = -1;

    public static synchronized void setLastToolPickSlot(int lastToolPickSlot) {
        ToolPicker.lastToolPickSlot = lastToolPickSlot;
    }

    public int findToolFor(class_2680 blockState) {
        class_1799 stack;
        float bestBreakSpeed = 1.0f;
        int bestSpeedSlot = -1;
        int invSize = this.canPickFromInventory() ? this.inventory.field_7547.size() : 9;
        int selectedSlot = this.inventory.field_7545;
        for (int i = 1; i <= invSize; ++i) {
            int index = (i + lastToolPickSlot) % invSize;
            if (index == selectedSlot) continue;
            class_1799 stack2 = (class_1799)this.inventory.field_7547.get(index);
            if (stack2.method_7951(blockState)) {
                return index;
            }
            float breakSpeed = stack2.method_7924(blockState);
            if (!(breakSpeed > bestBreakSpeed)) continue;
            bestSpeedSlot = index;
            bestBreakSpeed = breakSpeed;
        }
        if (bestSpeedSlot == -1 && ((stack = (class_1799)this.inventory.field_7547.get(selectedSlot)).method_7951(blockState) || stack.method_7924(blockState) > 1.0f)) {
            return selectedSlot;
        }
        return bestSpeedSlot;
    }

    public boolean pickToolFor(class_2680 blockState) {
        return this.pick(this.findToolFor(blockState));
    }

    public int findWeapon() {
        int invSize = this.canPickFromInventory() ? this.inventory.field_7547.size() : 9;
        for (int i = 1; i <= invSize; ++i) {
            int index = (i + lastToolPickSlot) % invSize;
            if (index == this.inventory.field_7545 || !MWClient.isWeapon((class_1799)this.inventory.field_7547.get(index))) continue;
            return index;
        }
        return -1;
    }

    public boolean pickWeapon() {
        return this.pick(this.findWeapon());
    }

    private boolean canPickFromInventory() {
        return MouseWheelie.config.toolPicking.pickFromInventory;
    }

    private boolean pick(int index) {
        ToolPicker.setLastToolPickSlot(index);
        if (index != -1 && index != this.inventory.field_7545) {
            if (class_1661.method_7380((int)index)) {
                this.inventory.field_7545 = index;
            } else {
                MWClientNetworking.pickFromInventory(index);
            }
            return true;
        }
        return false;
    }

    @Generated
    public ToolPicker(class_1661 inventory) {
        this.inventory = inventory;
    }
}

