/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.network;

import de.siphalor.mousewheelie.MouseWheelie;
import de.siphalor.mousewheelie.client.MWClient;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2846;
import net.minecraft.class_310;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class InteractionManager {
    @Generated
    private static final Logger log = MouseWheelie.createLogger(InteractionManager.class);
    private static final Queue<InteractionEvent> interactionEventQueue = new ArrayDeque<InteractionEvent>();
    private static final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(1);
    private static ScheduledFuture<?> tickFuture;
    public static final Waiter DUMMY_WAITER;
    public static final Waiter TICK_WAITER;
    public static final PacketEvent SWAP_WITH_OFFHAND_EVENT;
    private static Waiter waiter;

    public static void delay(Runnable action, Duration duration) {
        scheduledExecutor.schedule(action, duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void push(InteractionEvent interactionEvent) {
        if (interactionEvent == null) {
            return;
        }
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            interactionEventQueue.add(interactionEvent);
            if (waiter == null) {
                InteractionManager.triggerSend(TriggerType.INITIAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushAll(Collection<InteractionEvent> interactionEvents) {
        if (interactionEvents == null) {
            return;
        }
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            interactionEventQueue.addAll(interactionEvents);
            if (waiter == null) {
                InteractionManager.triggerSend(TriggerType.INITIAL);
            }
        }
    }

    public static void pushClickEvent(int containerSyncId, int slotId, int buttonId, class_1713 slotAction) {
        InteractionManager.push(new ClickEvent(containerSyncId, slotId, buttonId, slotAction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void triggerSend(TriggerType triggerType) {
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            if (waiter == null || waiter.trigger(triggerType)) {
                do {
                    InteractionEvent event;
                    if ((event = interactionEventQueue.poll()) == null) {
                        waiter = null;
                        break;
                    }
                    InteractionManager.doSendEvent(event);
                } while (waiter.trigger(TriggerType.INITIAL));
            }
        }
    }

    private static void doSendEvent(InteractionEvent event) {
        if (event.shouldRunOnMainThread()) {
            InteractionManager.runOnMainThread(event);
        } else {
            waiter = event.send();
        }
    }

    private static void runOnMainThread(InteractionEvent event) {
        Waiter blockingWaiter;
        waiter = blockingWaiter = tt -> false;
        class_310.method_1551().execute(() -> {
            Queue<InteractionEvent> queue = interactionEventQueue;
            synchronized (queue) {
                if (waiter == blockingWaiter) {
                    waiter = event.send();
                }
            }
        });
    }

    public static void setTickRate(long milliSeconds) {
        if (tickFuture != null) {
            tickFuture.cancel(false);
        }
        tickFuture = scheduledExecutor.scheduleAtFixedRate(InteractionManager::tick, milliSeconds, milliSeconds, TimeUnit.MILLISECONDS);
    }

    public static void tick() {
        try {
            InteractionManager.triggerSend(TriggerType.TICK);
        }
        catch (Exception e) {
            log.error("Error while ticking InteractionManager", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWaiter(Waiter waiter) {
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            InteractionManager.waiter = waiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            interactionEventQueue.clear();
            waiter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady() {
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            return waiter == null && interactionEventQueue.isEmpty();
        }
    }

    static {
        DUMMY_WAITER = triggerType -> true;
        TICK_WAITER = triggerType -> triggerType == TriggerType.TICK;
        SWAP_WITH_OFFHAND_EVENT = new PacketEvent((class_2596<?>)new class_2846(class_2846.class_2847.field_12969, class_2338.field_10980, class_2350.field_11033), triggerType -> triggerType == TriggerType.CONTAINER_SLOT_UPDATE && MWClient.lastUpdatedSlot == 45);
        waiter = null;
    }

    @FunctionalInterface
    public static interface Waiter {
        public boolean trigger(TriggerType var1);

        public static Waiter equal(TriggerType triggerType) {
            return triggerType::equals;
        }
    }

    public static enum TriggerType {
        INITIAL,
        CONTAINER_SLOT_UPDATE,
        GUI_CONFIRM,
        HELD_ITEM_CHANGE,
        TICK;

    }

    public static class ClickEvent
    implements InteractionEvent {
        private final Waiter waiter;
        private final int containerSyncId;
        private final int slotId;
        private final int buttonId;
        private final class_1713 slotAction;

        public ClickEvent(int containerSyncId, int slotId, int buttonId, class_1713 slotAction) {
            this(containerSyncId, slotId, buttonId, slotAction, TICK_WAITER);
        }

        public ClickEvent(int containerSyncId, int slotId, int buttonId, class_1713 slotAction, Waiter waiter) {
            this.containerSyncId = containerSyncId;
            this.slotId = slotId;
            this.buttonId = buttonId;
            this.slotAction = slotAction;
            this.waiter = waiter;
        }

        @Override
        public Waiter send() {
            class_310.method_1551().field_1761.method_2906(this.containerSyncId, this.slotId, this.buttonId, this.slotAction, (class_1657)class_310.method_1551().field_1724);
            return this.waiter;
        }

        @Override
        public boolean shouldRunOnMainThread() {
            return true;
        }
    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public Waiter send();

        default public boolean shouldRunOnMainThread() {
            return false;
        }
    }

    public static class PacketEvent
    implements InteractionEvent {
        private final class_2596<?> packet;
        private final Waiter waiter;

        public PacketEvent(class_2596<?> packet) {
            this(packet, DUMMY_WAITER);
        }

        public PacketEvent(class_2596<?> packet, int triggers) {
            this(packet, new SlotUpdateWaiter(triggers));
        }

        public PacketEvent(class_2596<?> packet, Waiter waiter) {
            this.packet = packet;
            this.waiter = waiter;
        }

        @Override
        public Waiter send() {
            class_310.method_1551().method_1562().method_2883(this.packet);
            return this.waiter;
        }
    }

    public static class CallbackEvent
    implements InteractionEvent {
        private final Supplier<Waiter> callback;
        private final boolean shouldRunOnMainThread;

        public CallbackEvent(Supplier<Waiter> callback) {
            this(callback, false);
        }

        public CallbackEvent(Supplier<Waiter> callback, boolean shouldRunOnMainThread) {
            this.callback = callback;
            this.shouldRunOnMainThread = shouldRunOnMainThread;
        }

        @Override
        public Waiter send() {
            return this.callback.get();
        }

        @Override
        public boolean shouldRunOnMainThread() {
            return this.shouldRunOnMainThread;
        }
    }

    public static class SlotUpdateWaiter
    implements Waiter {
        int triggers;

        public SlotUpdateWaiter(int triggers) {
            this.triggers = triggers;
        }

        @Override
        public boolean trigger(TriggerType triggerType) {
            return triggerType == TriggerType.CONTAINER_SLOT_UPDATE && --this.triggers == 0;
        }
    }

    @Deprecated
    public static class GuiConfirmWaiter
    implements Waiter {
        int triggers;

        public GuiConfirmWaiter(int triggers) {
            this.triggers = triggers;
        }

        @Override
        public boolean trigger(TriggerType triggerType) {
            return triggerType == TriggerType.GUI_CONFIRM && --this.triggers == 0;
        }
    }
}

