/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client;

import de.siphalor.amecs.api.KeyModifiers;
import de.siphalor.coat.screen.ConfigScreen;
import de.siphalor.coat.util.EnumeratedMaterial;
import de.siphalor.mousewheelie.MWConfig;
import de.siphalor.mousewheelie.MouseWheelie;
import de.siphalor.mousewheelie.client.inventory.ToolPicker;
import de.siphalor.mousewheelie.client.inventory.sort.SortMode;
import de.siphalor.mousewheelie.client.keybinding.ActionModifierKeybinding;
import de.siphalor.mousewheelie.client.keybinding.OpenConfigScreenKeybinding;
import de.siphalor.mousewheelie.client.keybinding.PickToolKeyBinding;
import de.siphalor.mousewheelie.client.keybinding.ScrollKeyBinding;
import de.siphalor.mousewheelie.client.keybinding.SortKeyBinding;
import de.siphalor.mousewheelie.client.network.InteractionManager;
import de.siphalor.mousewheelie.client.util.CreativeSearchOrder;
import de.siphalor.mousewheelie.client.util.ScrollAction;
import de.siphalor.mousewheelie.client.util.inject.IContainerScreen;
import de.siphalor.mousewheelie.client.util.inject.IScrollableRecipeBook;
import de.siphalor.mousewheelie.client.util.inject.ISpecialScrollableScreen;
import de.siphalor.tweed5.coat.bridge.api.ConfigScreenCreateParams;
import de.siphalor.tweed5.coat.bridge.api.TweedCoatBridgeExtension;
import de.siphalor.tweed5.coat.bridge.api.TweedCoatMappers;
import de.siphalor.tweed5.defaultextensions.presets.api.PresetsExtension;
import java.util.Arrays;
import java.util.Locale;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1835;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class MWClient
implements ClientModInitializer {
    private static final class_310 CLIENT = class_310.method_1551();
    public static final class_304.class_11900 KEY_BINDING_CATEGORY = new class_304.class_11900(class_2960.method_60655((String)"mousewheelie", (String)"main"));
    public static final class_304 OPEN_CONFIG_SCREEN = new OpenConfigScreenKeybinding(MouseWheelie.createId("open_config_screen"), class_3675.class_307.field_1668, -1, KEY_BINDING_CATEGORY, new KeyModifiers());
    public static final class_304 SORT_KEY_BINDING = new SortKeyBinding(MouseWheelie.createId("sort_inventory"), class_3675.class_307.field_1672, 2, KEY_BINDING_CATEGORY, new KeyModifiers());
    public static final class_304 SCROLL_UP_KEY_BINDING = new ScrollKeyBinding(MouseWheelie.createId("scroll_up"), KEY_BINDING_CATEGORY, false);
    public static final class_304 SCROLL_DOWN_KEY_BINDING = new ScrollKeyBinding(MouseWheelie.createId("scroll_down"), KEY_BINDING_CATEGORY, true);
    public static final class_304 PICK_TOOL_KEY_BINDING = new PickToolKeyBinding(MouseWheelie.createId("pick_tool"), class_3675.class_307.field_1668, -1, KEY_BINDING_CATEGORY, new KeyModifiers());
    public static final ActionModifierKeybinding WHOLE_STACK_MODIFIER = new ActionModifierKeybinding(MouseWheelie.createId("whole_stack_modifier"), class_3675.class_307.field_1668, 340, KEY_BINDING_CATEGORY, new KeyModifiers());
    public static final ActionModifierKeybinding ALL_OF_KIND_MODIFIER = new ActionModifierKeybinding(MouseWheelie.createId("all_of_kind_modifier"), class_3675.class_307.field_1668, 341, KEY_BINDING_CATEGORY, new KeyModifiers());
    public static final ActionModifierKeybinding DROP_MODIFIER = new ActionModifierKeybinding(MouseWheelie.createId("drop_modifier"), class_3675.class_307.field_1668, 342, KEY_BINDING_CATEGORY, new KeyModifiers());
    public static final ActionModifierKeybinding DEPOSIT_MODIFIER = new ActionModifierKeybinding(MouseWheelie.createId("deposit_modifier"), class_3675.class_307.field_1668, 32, KEY_BINDING_CATEGORY, new KeyModifiers());
    public static final ActionModifierKeybinding RESTOCK_MODIFIER = new ActionModifierKeybinding(MouseWheelie.createId("restock_modifier"), class_3675.class_307.field_1668, 32, KEY_BINDING_CATEGORY, new KeyModifiers());
    public static int lastUpdatedSlot = -1;

    public void onInitializeClient() {
        KeyBindingHelper.registerKeyBinding((class_304)OPEN_CONFIG_SCREEN);
        KeyBindingHelper.registerKeyBinding((class_304)SORT_KEY_BINDING);
        KeyBindingHelper.registerKeyBinding((class_304)SCROLL_UP_KEY_BINDING);
        KeyBindingHelper.registerKeyBinding((class_304)SCROLL_DOWN_KEY_BINDING);
        KeyBindingHelper.registerKeyBinding((class_304)PICK_TOOL_KEY_BINDING);
        KeyBindingHelper.registerKeyBinding((class_304)WHOLE_STACK_MODIFIER);
        KeyBindingHelper.registerKeyBinding((class_304)ALL_OF_KIND_MODIFIER);
        KeyBindingHelper.registerKeyBinding((class_304)DROP_MODIFIER);
        KeyBindingHelper.registerKeyBinding((class_304)DEPOSIT_MODIFIER);
        KeyBindingHelper.registerKeyBinding((class_304)RESTOCK_MODIFIER);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            CreativeSearchOrder.refreshItemSearchPositionLookup();
            MWClient.updateTickRate();
        });
    }

    public static boolean isTool(class_1799 stack) {
        return stack.method_57826(class_9334.field_50077);
    }

    public static boolean isWeapon(class_1799 stack) {
        return stack.method_7909() instanceof class_1811 || stack.method_7909() instanceof class_1835 || stack.method_31573(class_3489.field_50108);
    }

    public static double getMouseX() {
        return MWClient.CLIENT.field_1729.method_1603() * (double)CLIENT.method_22683().method_4486() / (double)CLIENT.method_22683().method_4480();
    }

    public static double getMouseY() {
        return MWClient.CLIENT.field_1729.method_1604() * (double)CLIENT.method_22683().method_4502() / (double)CLIENT.method_22683().method_4507();
    }

    public static boolean isScrollModeToggled() {
        return class_310.method_1551().method_74189();
    }

    public static void onConfigChanged() {
        CreativeSearchOrder.refreshItemSearchPositionLookup();
        MWClient.updateTickRate();
    }

    private static void updateTickRate() {
        if (MWClient.isOnLocalServer()) {
            InteractionManager.setTickRate(MouseWheelie.config.general.integratedInteractionRate);
        } else {
            InteractionManager.setTickRate(MouseWheelie.config.general.interactionRate);
        }
    }

    public static boolean isOnLocalServer() {
        return CLIENT.method_1576() != null;
    }

    public static boolean triggerScroll(double mouseX, double mouseY, double scrollY) {
        ScrollAction result;
        double scrollAmount = scrollY * (Double)MWClient.CLIENT.field_1690.method_41806().method_41753();
        if (MWClient.CLIENT.field_1755 instanceof ISpecialScrollableScreen && (result = ((ISpecialScrollableScreen)MWClient.CLIENT.field_1755).mouseWheelie_onMouseScrolledSpecial(mouseX, mouseY, scrollAmount)).cancelsCustomActions()) {
            return result.cancelsAllActions();
        }
        if (MWClient.CLIENT.field_1755 instanceof IContainerScreen && (result = ((IContainerScreen)MWClient.CLIENT.field_1755).mouseWheelie_onMouseScroll(mouseX, mouseY, scrollY)).cancelsCustomActions()) {
            return result.cancelsAllActions();
        }
        if (MWClient.CLIENT.field_1755 instanceof IScrollableRecipeBook && (result = ((IScrollableRecipeBook)MWClient.CLIENT.field_1755).mouseWheelie_onMouseScrollRecipeBook(mouseX, mouseY, scrollY)).cancelsCustomActions()) {
            return result.cancelsAllActions();
        }
        return false;
    }

    public static boolean triggerPick(class_1657 player, class_239 hitResult) {
        class_2680 blockState;
        class_1799 stack = player.method_6047();
        class_1792 item = stack.method_7909();
        if (MouseWheelie.config.toolPicking.holdTool && (MWClient.isTool(stack) || MWClient.isWeapon(stack))) {
            class_2680 blockState2;
            ToolPicker toolPicker = new ToolPicker(player.method_31548());
            if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965 ? toolPicker.pickToolFor(blockState2 = player.method_73183().method_8320(((class_3965)hitResult).method_17777())) : toolPicker.pickWeapon()) {
                return true;
            }
        }
        if (MouseWheelie.config.toolPicking.holdBlock && item instanceof class_1747 && hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965 && (blockState = player.method_73183().method_8320(((class_3965)hitResult).method_17777())).method_26204() == ((class_1747)item).method_7711()) {
            ToolPicker toolPicker = new ToolPicker(player.method_31548());
            return toolPicker.pickToolFor(blockState);
        }
        return false;
    }

    public static ConfigScreen createConfigScreen() {
        TweedCoatBridgeExtension coatBridge = (TweedCoatBridgeExtension)MouseWheelie.configContainerHelper.configContainer().extension(TweedCoatBridgeExtension.class).orElseThrow(() -> new IllegalStateException("Failed to get TweedCoatBridgeExtension"));
        Arrays.asList(TweedCoatMappers.booleanCheckboxMapper(), TweedCoatMappers.integerTextMapper(), TweedCoatMappers.enumCycleButtonMapper(), TweedCoatMappers.enumeratedMaterialCycleButtonMapper(SortMode.class, (EnumeratedMaterial)new EnumeratedMaterial<SortMode>(){

            public SortMode[] values() {
                return SortMode.getAll().toArray(new SortMode[0]);
            }

            public class_2561 asText(SortMode sortMode) {
                return class_2561.method_43471((String)("mousewheelie.sortmode." + sortMode.name().toLowerCase(Locale.ROOT)));
            }
        }), TweedCoatMappers.compoundCategoryMapper()).forEach(arg_0 -> ((TweedCoatBridgeExtension)coatBridge).addMapper(arg_0));
        MWConfig defaultValue = (MWConfig)MouseWheelie.configContainerHelper.configContainer().rootEntry().call(PresetsExtension.presetValue((String)"default"));
        return coatBridge.createConfigScreen(ConfigScreenCreateParams.builder().rootEntry(MouseWheelie.configContainerHelper.configContainer().rootEntry()).currentValue((Object)MouseWheelie.config).defaultValue((Object)defaultValue).title((class_2561)class_2561.method_43471((String)"tweed4_tailor_screen.screen.mousewheelie")).translationKeyPrefix("tweed4_tailor_screen.screen.mousewheelie").saveHandler(value -> {
            MouseWheelie.config = value;
            MouseWheelie.configContainerHelper.writeConfigInConfigDirectory(value);
            MWClient.onConfigChanged();
        }).build());
    }
}

