/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.inventory;

import de.siphalor.mousewheelie.MouseWheelie;
import de.siphalor.mousewheelie.client.network.InteractionManager;
import de.siphalor.mousewheelie.client.network.MWClientNetworking;
import de.siphalor.mousewheelie.client.util.ItemStackUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2596;
import net.minecraft.class_2868;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7706;
import net.minecraft.class_9334;
import net.minecraft.class_9701;

@Environment(value=EnvType.CLIENT)
public class SlotRefiller {
    private static final long MAX_REFILL_MILLIS = 5000L;
    private static final InteractionManager.InteractionEvent REFILL_END_EVENT = () -> {
        SlotRefiller.endRefill();
        return InteractionManager.DUMMY_WAITER;
    };
    private static class_1661 playerInventory;
    private static class_1799 stack;
    private static long refillStartTime;
    private static final ConcurrentLinkedDeque<Rule> rules;
    private static class_1268 refillHand;

    private SlotRefiller() {
    }

    public static boolean scheduleRefillChecked(class_1268 hand, class_1661 inventory, class_1799 oldStack, class_1799 newStack) {
        if (class_310.method_1551().field_1755 != null) {
            return false;
        }
        if (!oldStack.method_7960() && (newStack.method_7960() || MouseWheelie.config.refill.itemChanges && oldStack.method_7909() != newStack.method_7909())) {
            SlotRefiller.scheduleRefillUnchecked(hand, inventory, oldStack.method_7972());
            return true;
        }
        return false;
    }

    public static void scheduleRefillUnchecked(class_1268 hand, class_1661 inventory, class_1799 referenceStack) {
        refillHand = hand;
        SlotRefiller.setupRefill(inventory, referenceStack);
    }

    public static boolean performRefill() {
        if (refillHand == null) {
            return false;
        }
        class_1268 hand = refillHand;
        refillHand = null;
        if (hand == class_1268.field_5810 && !MouseWheelie.config.refill.offHand) {
            return false;
        }
        SlotRefiller.refill(hand);
        return true;
    }

    public static void setupRefill(class_1661 playerInventory, class_1799 stack) {
        SlotRefiller.playerInventory = playerInventory;
        SlotRefiller.stack = stack;
    }

    @Deprecated
    public static boolean refill() {
        return SlotRefiller.refill(class_1268.field_5808);
    }

    public static boolean refill(class_1268 hand) {
        if (SlotRefiller.isRefillInProgress()) {
            return false;
        }
        if (!((List)stack.method_58695(class_9701.field_51678, Collections.emptyList())).isEmpty()) {
            return false;
        }
        Iterator<Rule> iterator = rules.descendingIterator();
        while (iterator.hasNext()) {
            int slot;
            Rule rule = iterator.next();
            if (!rule.matches(stack) || (slot = rule.findMatchingStack(playerInventory, stack)) == -1) continue;
            SlotRefiller.startRefill();
            SlotRefiller.refillFromSlot(hand, slot);
            return true;
        }
        return false;
    }

    private static void startRefill() {
        refillStartTime = System.currentTimeMillis();
        SlotRefiller.scheduleRefillSound();
    }

    private static void endRefill() {
        refillStartTime = System.currentTimeMillis() - 5000L;
    }

    private static boolean isRefillInProgress() {
        return System.currentTimeMillis() - refillStartTime < 5000L;
    }

    private static void scheduleRefillSound() {
        if (MouseWheelie.config.refill.playSound) {
            InteractionManager.delay(SlotRefiller::playRefillSound, Duration.of(200L, ChronoUnit.MILLIS));
        }
    }

    private static void playRefillSound() {
        if (MouseWheelie.config.refill.playSound) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_15197, (float)0.2f, (float)1.0f));
        }
    }

    private static void refillFromSlot(class_1268 hand, int slot) {
        if (slot == playerInventory.method_67532()) {
            return;
        }
        if (class_1661.method_7380((int)slot)) {
            SlotRefiller.refillFromHotbar(hand, slot);
        } else {
            SlotRefiller.refillFromInventory(hand, slot);
        }
        InteractionManager.push(REFILL_END_EVENT);
    }

    private static void refillFromHotbar(class_1268 hand, int hotbarSlot) {
        if (MouseWheelie.config.refill.restoreSelectedSlot) {
            class_1799 offhandStack = SlotRefiller.playerInventory.field_7546.method_6079();
            if (hand == class_1268.field_5808 && !offhandStack.method_7960()) {
                InteractionManager.push(InteractionManager.SWAP_WITH_OFFHAND_EVENT);
            }
            InteractionManager.push(new InteractionManager.PacketEvent((class_2596<?>)new class_2868(hotbarSlot), InteractionManager.Waiter.equal(InteractionManager.TriggerType.HELD_ITEM_CHANGE)));
            InteractionManager.push(InteractionManager.SWAP_WITH_OFFHAND_EVENT);
            InteractionManager.push(new InteractionManager.PacketEvent((class_2596<?>)new class_2868(playerInventory.method_67532()), InteractionManager.TICK_WAITER));
            if (hand == class_1268.field_5808) {
                InteractionManager.push(InteractionManager.SWAP_WITH_OFFHAND_EVENT);
            }
        } else {
            if (hand == class_1268.field_5810) {
                InteractionManager.push(InteractionManager.SWAP_WITH_OFFHAND_EVENT);
            }
            playerInventory.method_61496(hotbarSlot);
            InteractionManager.push(new InteractionManager.PacketEvent((class_2596<?>)new class_2868(hotbarSlot), InteractionManager.TICK_WAITER));
            if (hand == class_1268.field_5810) {
                InteractionManager.push(InteractionManager.SWAP_WITH_OFFHAND_EVENT);
            }
        }
    }

    private static void refillFromInventory(class_1268 hand, int inventorySlot) {
        if (hand == class_1268.field_5810) {
            class_1799 mainHandStack = playerInventory.method_7391();
            InteractionManager.push(InteractionManager.SWAP_WITH_OFFHAND_EVENT);
            MWClientNetworking.pickFromInventory(inventorySlot);
            InteractionManager.push(InteractionManager.SWAP_WITH_OFFHAND_EVENT);
            InteractionManager.push(() -> {
                playerInventory.method_5447(playerInventory.method_67532(), mainHandStack);
                return InteractionManager.DUMMY_WAITER;
            });
        } else {
            MWClientNetworking.pickFromInventory(inventorySlot);
        }
    }

    private static int findBestThroughClassHierarchy(class_1799 baseStack, class_1661 inventory, Function<class_1792, Class<?>> getClass, Class<?> baseClass) {
        Class<?> clazz;
        int currentRank = 0;
        ArrayList classes = new ArrayList(10);
        for (clazz = getClass.apply(baseStack.method_7909()); clazz != baseClass; clazz = clazz.getSuperclass()) {
            classes.add(clazz);
        }
        int classesSize = classes.size();
        if (classesSize == 0) {
            return -1;
        }
        int index = -1;
        int invSize = inventory.method_5439();
        block1: for (int i = 0; i < invSize; ++i) {
            clazz = getClass.apply(inventory.method_5438(i).method_7909());
            if (clazz == null) continue;
            while (clazz != baseClass) {
                Iterator iterator = classes.iterator();
                for (int classRank = classesSize; iterator.hasNext() && classRank > 0; --classRank) {
                    if (classRank <= currentRank) continue block1;
                    if (!Objects.equals(clazz, iterator.next())) continue;
                    if (classRank >= classesSize) {
                        return i;
                    }
                    currentRank = classRank;
                    index = i;
                    continue block1;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return index;
    }

    static {
        refillStartTime = System.currentTimeMillis() - 5000L;
        rules = new ConcurrentLinkedDeque();
        refillHand = null;
        rules.add(new BlockRule());
        rules.add(new ItemGroupRule());
        rules.add(new ItemHierarchyRule());
        rules.add(new BlockHierarchyRule());
        rules.add(new FoodRule());
        rules.add(new EqualItemRule());
        rules.add(new EqualStackRule());
    }

    public static abstract class Rule {
        protected Rule() {
            rules.add(this);
        }

        abstract boolean matches(class_1799 var1);

        abstract int findMatchingStack(class_1661 var1, class_1799 var2);

        protected int iterateInventory(class_1661 playerInventory, Predicate<class_1799> predicate) {
            int invSize = playerInventory.method_5439();
            for (int i = 0; i < invSize; ++i) {
                if (!predicate.test(playerInventory.method_5438(i))) continue;
                return i;
            }
            return -1;
        }
    }

    public static class BlockRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MouseWheelie.config.refill.rules.anyBlock && oldStack.method_7909() instanceof class_1747;
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            return this.iterateInventory(playerInventory, stack -> stack.method_7909() instanceof class_1747);
        }
    }

    public static class ItemGroupRule
    extends Rule {
        private static boolean containsBroad(class_1761 group, class_1799 stack) {
            return group.method_45412(stack) || group.method_45412(stack.method_7909().method_7854());
        }

        @Override
        boolean matches(class_1799 oldStack) {
            if (!MouseWheelie.config.refill.rules.itemgroup) {
                return false;
            }
            for (class_1761 group : class_7706.method_47341()) {
                if (!ItemGroupRule.containsBroad(group, oldStack)) continue;
                return true;
            }
            return false;
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            ArrayList<class_1761> checkGroups = new ArrayList<class_1761>();
            for (class_1761 group : class_7706.method_47341()) {
                if (!ItemGroupRule.containsBroad(group, oldStack)) continue;
                checkGroups.add(group);
            }
            if (checkGroups.isEmpty()) {
                return -1;
            }
            return this.iterateInventory(playerInventory, stack -> {
                for (class_1761 group : checkGroups) {
                    if (!ItemGroupRule.containsBroad(group, stack)) continue;
                    return true;
                }
                return false;
            });
        }
    }

    public static class ItemHierarchyRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MouseWheelie.config.refill.rules.itemHierarchy && oldStack.method_7909().getClass() != class_1792.class && !(oldStack.method_7909() instanceof class_1747);
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            return SlotRefiller.findBestThroughClassHierarchy(oldStack, playerInventory, Object::getClass, class_1792.class);
        }
    }

    public static class BlockHierarchyRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MouseWheelie.config.refill.rules.blockHierarchy && oldStack.method_7909() instanceof class_1747;
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            return SlotRefiller.findBestThroughClassHierarchy(oldStack, playerInventory, item -> {
                if (item instanceof class_1747) {
                    return ((class_1747)item).method_7711().getClass();
                }
                return null;
            }, class_2248.class);
        }
    }

    public static class FoodRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MouseWheelie.config.refill.rules.food && FoodRule.isEdible(oldStack);
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            return this.iterateInventory(playerInventory, FoodRule::isEdible);
        }

        private static boolean isEdible(class_1799 stack) {
            return stack.method_57826(class_9334.field_50075);
        }
    }

    public static class EqualItemRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MouseWheelie.config.refill.rules.equalItems;
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            class_1792 item = oldStack.method_7909();
            return this.iterateInventory(playerInventory, stack -> stack.method_7909() == item);
        }
    }

    public static class EqualStackRule
    extends Rule {
        @Override
        boolean matches(class_1799 oldStack) {
            return MouseWheelie.config.refill.rules.equalStacks;
        }

        @Override
        int findMatchingStack(class_1661 playerInventory, class_1799 oldStack) {
            return this.iterateInventory(playerInventory, stack -> ItemStackUtils.canCombine(stack, oldStack));
        }
    }
}

