/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.common.network;

import de.siphalor.mousewheelie.MouseWheelie;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import lombok.Generated;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8703;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ReorderInventoryPacket
implements class_8710 {
    @Generated
    private static final Logger log = MouseWheelie.createLogger(ReorderInventoryPacket.class);
    public static final class_2960 PAYLOAD_ID = MouseWheelie.createId("reorder_inventory");
    public static final class_8710.class_9154<ReorderInventoryPacket> TYPE = new class_8710.class_9154(PAYLOAD_ID);
    private static final int MAX_SLOTS = 2048;
    private static final class_9139<ByteBuf, int[]> INT_ARRAY_STREAM_CODEC = new class_9139<ByteBuf, int[]>(){

        public void encode(ByteBuf byteBuf, int[] array) {
            class_9135.method_57990((ByteBuf)byteBuf, (int)array.length, (int)2048);
            for (int value : array) {
                class_8703.method_53017((ByteBuf)byteBuf, (int)value);
            }
        }

        public int @NotNull [] decode(ByteBuf byteBuf) {
            int length = class_9135.method_57989((ByteBuf)byteBuf, (int)2048);
            int[] array = new int[length];
            for (int i = 0; i < length; ++i) {
                array[i] = class_8703.method_53016((ByteBuf)byteBuf);
            }
            return array;
        }
    };
    public static final class_9139<ByteBuf, ReorderInventoryPacket> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48550, ReorderInventoryPacket::getSyncId, INT_ARRAY_STREAM_CODEC, ReorderInventoryPacket::getSlotMappings, ReorderInventoryPacket::new);
    private final int syncId;
    private final int[] slotMappings;

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public void write(@NotNull class_2540 buf) {
        buf.method_10804(this.syncId);
        buf.method_10806(this.slotMappings);
    }

    @Nullable
    public static ReorderInventoryPacket read(class_2540 buf) {
        int syncId = buf.method_10816();
        int[] reorderedIndices = buf.method_10787();
        if (reorderedIndices.length % 2 != 0) {
            log.warn("Received reorder inventory packet with invalid data!");
            return null;
        }
        return new ReorderInventoryPacket(syncId, reorderedIndices);
    }

    @Generated
    public ReorderInventoryPacket(int syncId, int[] slotMappings) {
        this.syncId = syncId;
        this.slotMappings = slotMappings;
    }

    @Generated
    public int getSyncId() {
        return this.syncId;
    }

    @Generated
    public int[] getSlotMappings() {
        return this.slotMappings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReorderInventoryPacket)) {
            return false;
        }
        ReorderInventoryPacket other = (ReorderInventoryPacket)o;
        if (this.getSyncId() != other.getSyncId()) {
            return false;
        }
        return Arrays.equals(this.getSlotMappings(), other.getSlotMappings());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSyncId();
        result = result * 59 + Arrays.hashCode(this.getSlotMappings());
        return result;
    }

    @Generated
    public String toString() {
        return "ReorderInventoryPacket(syncId=" + this.getSyncId() + ", slotMappings=" + Arrays.toString(this.getSlotMappings()) + ")";
    }
}

