/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.common.network;

import de.siphalor.mousewheelie.MouseWheelie;
import java.util.Arrays;
import lombok.Generated;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ReorderInventoryPacket {
    @Generated
    private static final Logger log = MouseWheelie.createLogger(ReorderInventoryPacket.class);
    private final int syncId;
    private final int[] slotMappings;

    public void write(@NotNull class_2540 buf) {
        buf.method_10804(this.syncId);
        buf.method_10806(this.slotMappings);
    }

    @Nullable
    public static ReorderInventoryPacket read(class_2540 buf) {
        int syncId = buf.method_10816();
        int[] reorderedIndices = buf.method_10787();
        if (reorderedIndices.length % 2 != 0) {
            log.warn("Received reorder inventory packet with invalid data!");
            return null;
        }
        return new ReorderInventoryPacket(syncId, reorderedIndices);
    }

    @Generated
    public ReorderInventoryPacket(int syncId, int[] slotMappings) {
        this.syncId = syncId;
        this.slotMappings = slotMappings;
    }

    @Generated
    public int getSyncId() {
        return this.syncId;
    }

    @Generated
    public int[] getSlotMappings() {
        return this.slotMappings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReorderInventoryPacket)) {
            return false;
        }
        ReorderInventoryPacket other = (ReorderInventoryPacket)o;
        if (this.getSyncId() != other.getSyncId()) {
            return false;
        }
        return Arrays.equals(this.getSlotMappings(), other.getSlotMappings());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSyncId();
        result = result * 59 + Arrays.hashCode(this.getSlotMappings());
        return result;
    }

    @Generated
    public String toString() {
        return "ReorderInventoryPacket(syncId=" + this.getSyncId() + ", slotMappings=" + Arrays.toString(this.getSlotMappings()) + ")";
    }
}

