/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.util;

import com.google.common.collect.Sets;
import de.siphalor.mousewheelie.MouseWheelie;
import java.awt.Color;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9282;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ItemStackUtils {
    private static final class_1792.class_9635 TOOLTIP_CONTEXT = class_1792.class_9635.field_51353;

    public static boolean hasCustomData(class_1799 stack) {
        return !stack.method_57380().method_57848();
    }

    public static int getMaxStackSize(class_1799 stack) {
        return stack.method_7914();
    }

    public static boolean canCombine(class_1799 a, class_1799 b) {
        return class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    public static int compareEqualItems(class_1799 a, class_1799 b) {
        int cmp = Integer.compare(b.method_7947(), a.method_7947());
        if (cmp != 0) {
            return cmp;
        }
        return ItemStackUtils.compareEqualItems2(a, b);
    }

    private static int compareEqualItems2(class_1799 a, class_1799 b) {
        if (ItemStackUtils.hasCustomName(a)) {
            if (!ItemStackUtils.hasCustomName(b)) {
                return -1;
            }
            return ItemStackUtils.compareEqualItems3(a, b);
        }
        if (ItemStackUtils.hasCustomName(b)) {
            return 1;
        }
        return ItemStackUtils.compareEqualItems3(a, b);
    }

    private static boolean hasCustomName(class_1799 stack) {
        return stack.method_57826(class_9334.field_49631);
    }

    private static int compareEqualItems3(class_1799 a, class_1799 b) {
        Iterator tooltipsA = a.method_7950(TOOLTIP_CONTEXT, null, (class_1836)class_1836.class_1837.field_41070).iterator();
        Iterator tooltipsB = b.method_7950(TOOLTIP_CONTEXT, null, (class_1836)class_1836.class_1837.field_41070).iterator();
        while (tooltipsA.hasNext()) {
            if (!tooltipsB.hasNext()) {
                return 1;
            }
            int cmp = ((class_2561)tooltipsA.next()).getString().compareToIgnoreCase(((class_2561)tooltipsB.next()).getString());
            if (cmp == 0) continue;
            return cmp;
        }
        if (tooltipsB.hasNext()) {
            return -1;
        }
        return ItemStackUtils.compareEqualItems4(a, b);
    }

    private static int compareEqualItems4(class_1799 a, class_1799 b) {
        int colorA = class_9282.method_57470((class_1799)a, (int)0);
        int colorB = class_9282.method_57470((class_1799)b, (int)0);
        if (colorA == 0 && colorB != 0) {
            return -1;
        }
        if (colorA != 0 && colorB == 0) {
            return 1;
        }
        if (colorA != 0) {
            float[] hsbB;
            float[] hsbA = Color.RGBtoHSB(colorA >> 16 & 0xFF, colorA >> 8 & 0xFF, colorA & 0xFF, null);
            int cmp = Float.compare(hsbA[0], (hsbB = Color.RGBtoHSB(colorB >> 16 & 0xFF, colorB >> 8 & 0xFF, colorB & 0xFF, null))[0]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Float.compare(hsbA[1], hsbB[1]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Float.compare(hsbA[2], hsbB[2]);
            if (cmp != 0) {
                return cmp;
            }
        }
        return ItemStackUtils.compareEqualItems5(a, b);
    }

    private static int compareEqualItems5(class_1799 a, class_1799 b) {
        return Integer.compare(a.method_7919(), b.method_7919());
    }

    public static boolean areItemsOfSameKind(class_1799 stack1, class_1799 stack2) {
        return ItemStackUtils.areItemsOfSameKind(stack1, stack2, MouseWheelie.config.general.itemKindsNbtMatchMode);
    }

    public static boolean areItemsOfSameKind(class_1799 stack1, class_1799 stack2, NbtMatchMode mode) {
        switch (mode.ordinal()) {
            case 0: {
                return stack1.method_7909() == stack2.method_7909();
            }
            case 2: {
                return ItemStackUtils.canCombine(stack1, stack2);
            }
            case 1: {
                if (!class_1799.method_7984((class_1799)stack1, (class_1799)stack2)) {
                    return false;
                }
                return ItemStackUtils.areComponentsEqualExcept(stack1, stack2, class_9334.field_49629, class_9334.field_49633);
            }
        }
        return false;
    }

    private static boolean areComponentsEqualExcept(class_1799 a, class_1799 b, class_9331<?> ... keys) {
        HashSet checkedKeys;
        class_9323 componentsB;
        class_9323 componentsA = a.method_57353();
        if (!ItemStackUtils.areComponentsEqualExceptOneSided(componentsA, componentsB = b.method_57353(), checkedKeys = Sets.newHashSet((Object[])keys))) {
            return false;
        }
        return ItemStackUtils.areComponentsEqualExceptOneSided(componentsA, componentsB, checkedKeys);
    }

    private static boolean areComponentsEqualExceptOneSided(class_9323 componentsA, class_9323 componentsB, Set<class_9331<?>> checkedKeys) {
        for (class_9336 componentA : componentsA) {
            if (checkedKeys.contains(componentA.comp_2443())) continue;
            Object valueB = componentsB.method_57829(componentA.comp_2443());
            if (!Objects.equals(componentA.comp_2444(), valueB)) {
                return false;
            }
            checkedKeys.add(componentA.comp_2443());
        }
        return true;
    }

    public static int hashByKind(class_1799 stack, NbtMatchMode mode) {
        switch (mode.ordinal()) {
            case 0: {
                return stack.method_7909().hashCode();
            }
            case 2: {
                return stack.method_7909().hashCode() + stack.method_57380().hashCode();
            }
            case 1: {
                HashCodeBuilder hashCodeBuilder = new HashCodeBuilder().append((Object)stack.method_7909());
                stack.method_57380().method_57846().stream().filter(entry -> entry.getKey() != class_9334.field_49629 && entry.getKey() != class_9334.field_49633).sorted(Comparator.comparing(entry -> ((class_9331)entry.getKey()).hashCode())).forEachOrdered(entry -> hashCodeBuilder.append(entry.getKey()).append(entry.getValue()));
                return hashCodeBuilder.toHashCode();
            }
        }
        return 0;
    }

    public static enum NbtMatchMode {
        NONE,
        SOME,
        ALL;

    }
}

