/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.mixin.gui.screen;

import com.google.common.base.Suppliers;
import de.siphalor.mousewheelie.MouseWheelie;
import de.siphalor.mousewheelie.client.MWClient;
import de.siphalor.mousewheelie.client.inventory.BundleDragMode;
import de.siphalor.mousewheelie.client.inventory.ContainerScreenHelper;
import de.siphalor.mousewheelie.client.inventory.sort.InventorySorter;
import de.siphalor.mousewheelie.client.inventory.sort.SortMode;
import de.siphalor.mousewheelie.client.network.InteractionManager;
import de.siphalor.mousewheelie.client.util.ScrollAction;
import de.siphalor.mousewheelie.client.util.inject.IContainerScreen;
import de.siphalor.mousewheelie.client.util.inject.ISlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5537;
import net.minecraft.class_746;
import net.minecraft.class_9334;
import net.minecraft.class_9930;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class MixinAbstractContainerScreen
extends class_437
implements IContainerScreen {
    @Shadow
    @Final
    protected class_1703 field_2797;
    @Shadow
    protected class_1735 field_2787;
    @Shadow
    @Nullable
    private class_1735 field_2777;
    @Shadow
    protected boolean field_2794;
    @Shadow
    @Final
    private List<class_9930> field_52801;
    @Unique
    private final Supplier<ContainerScreenHelper<class_465<class_1703>>> screenHelper = Suppliers.memoize(() -> ContainerScreenHelper.of((class_465)this, (slot, data, slotActionType) -> new InteractionManager.CallbackEvent(() -> {
        this.method_2383(slot, ((ISlot)slot).mouseWheelie_getIdInContainer(), data, slotActionType);
        return InteractionManager.TICK_WAITER;
    }, true)));
    @Unique
    private class_1735 lastBundleInteractionSlot;
    @Unique
    private BundleDragMode bundleDragMode;

    protected MixinAbstractContainerScreen(class_2561 textComponent_1) {
        super(textComponent_1);
    }

    @Shadow
    protected abstract class_1735 method_64240(double var1, double var3);

    @Unique
    @Nullable
    private class_1735 findSlot(double x, double y) {
        return this.method_64240(x, y);
    }

    @Shadow
    protected abstract void method_2383(class_1735 var1, int var2, int var3, class_1713 var4);

    /*
     * WARNING - void declaration
     */
    @Inject(method={"mouseDragged"}, at={@At(value="RETURN")})
    public void onMouseDragged(double x, double y, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> cir) {
        class_1792 curX22;
        class_1799 cursorStack;
        double dist;
        List<Object> slots = Collections.emptyList();
        class_1735 hoveredSlot = this.findSlot(x, y);
        if (MouseWheelie.config.general.betterFastDragging && (dist = Math.sqrt(deltaX * deltaX + deltaY * deltaY)) > 16.0) {
            void var15_12;
            slots = new ArrayList();
            if (hoveredSlot != null) {
                slots.add(hoveredSlot);
            }
            boolean bl = false;
            while (var15_12 < class_3532.method_15357((double)(dist / 16.0))) {
                double curX22 = x + deltaX - deltaX / dist * 16.0 * (double)var15_12;
                double d = y + deltaY - deltaY / dist * 16.0 * (double)var15_12;
                class_1735 curSlot = this.findSlot(curX22, d);
                if (curSlot != null) {
                    slots.add(curSlot);
                }
                ++var15_12;
            }
        }
        if (slots.isEmpty()) {
            if (hoveredSlot != null && !hoveredSlot.method_7677().method_7960()) {
                slots = Collections.singletonList(hoveredSlot);
            } else {
                return;
            }
        }
        ContainerScreenHelper<class_465<class_1703>> screenHelper = this.screenHelper.get();
        if (button == 0) {
            if (MouseWheelie.config.general.enableDropModifier && MWClient.DROP_MODIFIER.method_1434()) {
                for (class_1735 class_17352 : slots) {
                    screenHelper.dropStackLocked(class_17352);
                }
            } else if (MWClient.WHOLE_STACK_MODIFIER.method_1434()) {
                for (class_1735 class_17353 : slots) {
                    screenHelper.sendStackLocked(class_17353);
                }
            } else if (MWClient.ALL_OF_KIND_MODIFIER.method_1434()) {
                for (class_1735 class_17354 : slots) {
                    screenHelper.sendAllOfAKind(class_17354);
                }
            }
        } else if (button == 1 && !(cursorStack = this.field_2797.method_34255()).method_7960() && this.bundleDragMode != null && (curX22 = cursorStack.method_7909()) instanceof class_5537) {
            class_5537 class_55372 = (class_5537)curX22;
            class_1735 lastSlot = null;
            for (class_1735 class_17355 : slots) {
                if (class_17355 == this.lastBundleInteractionSlot) continue;
                if (this.bundleDragMode == BundleDragMode.AUTO) {
                    if (class_17355.method_7677().method_7960()) {
                        if (class_55372.method_31567(cursorStack)) {
                            this.bundleDragMode = BundleDragMode.PUTTING_OUT;
                        }
                    } else {
                        this.bundleDragMode = BundleDragMode.PICKING_UP;
                    }
                }
                if (this.bundleDragMode == BundleDragMode.PICKING_UP && class_17355.method_7677().method_7960() || this.bundleDragMode == BundleDragMode.PUTTING_OUT && !class_17355.method_7677().method_7960()) continue;
                this.method_2383(class_17355, class_17355.field_7874, 1, class_1713.field_7790);
                lastSlot = class_17355;
            }
            if (lastSlot != null) {
                this.lastBundleInteractionSlot = lastSlot;
            }
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    public void onMouseClick(double x, double y, int button, CallbackInfoReturnable<Boolean> cir) {
        class_1792 class_17922;
        class_1799 cursorStack;
        if (button == 0) {
            class_1735 hoveredSlot = this.findSlot(x, y);
            if (hoveredSlot == null) {
                return;
            }
            boolean success = true;
            if (MouseWheelie.config.general.enableDropModifier && MWClient.DROP_MODIFIER.method_1434()) {
                if (MWClient.ALL_OF_KIND_MODIFIER.method_1434()) {
                    if (MWClient.WHOLE_STACK_MODIFIER.method_1434()) {
                        this.screenHelper.get().dropAllFrom(hoveredSlot);
                    } else {
                        this.screenHelper.get().dropAllOfAKind(hoveredSlot);
                    }
                } else {
                    this.method_2383(hoveredSlot, ((ISlot)hoveredSlot).mouseWheelie_getIdInContainer(), 1, class_1713.field_7795);
                }
            } else if (MWClient.ALL_OF_KIND_MODIFIER.method_1434()) {
                if (MWClient.WHOLE_STACK_MODIFIER.method_1434()) {
                    this.screenHelper.get().sendAllFrom(hoveredSlot);
                } else {
                    this.screenHelper.get().sendAllOfAKind(hoveredSlot);
                }
            } else if (MWClient.DEPOSIT_MODIFIER.method_1434()) {
                this.screenHelper.get().depositAllFrom(hoveredSlot);
            } else if (MWClient.RESTOCK_MODIFIER.method_1434()) {
                if (MWClient.WHOLE_STACK_MODIFIER.method_1434()) {
                    this.screenHelper.get().restockAll(hoveredSlot);
                } else {
                    this.screenHelper.get().restockAllOfAKind(hoveredSlot);
                }
            } else {
                success = false;
            }
            if (success) {
                cir.setReturnValue((Object)true);
            }
        } else if (button == 1 && !(cursorStack = this.field_2797.method_34255()).method_7960() && MouseWheelie.config.general.enableBundleDragging && (class_17922 = cursorStack.method_7909()) instanceof class_5537) {
            class_5537 item = (class_5537)class_17922;
            class_1735 hoveredSlot = this.findSlot(x, y);
            this.bundleDragMode = hoveredSlot == null ? BundleDragMode.AUTO : (hoveredSlot.method_7677().method_7960() ? (item.method_31567(cursorStack) ? BundleDragMode.PUTTING_OUT : BundleDragMode.AUTO) : BundleDragMode.PICKING_UP);
            if (hoveredSlot != null) {
                this.method_2383(hoveredSlot, hoveredSlot.field_7874, 1, class_1713.field_7790);
            }
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    public void onMouseRelease(double x, double y, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.bundleDragMode != null) {
            this.field_2777 = null;
            this.field_2794 = false;
            cir.setReturnValue((Object)true);
        }
        this.lastBundleInteractionSlot = null;
        this.bundleDragMode = null;
    }

    @Override
    public class_1735 mouseWheelie_getSlotAt(double mouseX, double mouseY) {
        return this.findSlot(mouseX, mouseY);
    }

    @Override
    public ScrollAction mouseWheelie_onMouseScroll(double mouseX, double mouseY, double scrollAmount) {
        if (MouseWheelie.config.scrolling.enable) {
            class_1304 equipmentSlot;
            class_1735 hoveredSlot = this.findSlot(mouseX, mouseY);
            if (MouseWheelie.config.scrolling.preferStackSpecialScrollActions) {
                if (!MWClient.isScrollModeToggled()) {
                    for (class_9930 slotMouseAction : this.field_52801) {
                        if (!slotMouseAction.method_61974(hoveredSlot)) continue;
                        return ScrollAction.ABORT;
                    }
                }
            } else if (MWClient.isScrollModeToggled()) {
                return ScrollAction.FAILURE;
            }
            if (hoveredSlot == null) {
                return ScrollAction.PASS;
            }
            if (hoveredSlot.method_7677().method_7960()) {
                return ScrollAction.PASS;
            }
            if (scrollAmount < 0.0 && this instanceof class_490 && (equipmentSlot = MixinAbstractContainerScreen.getEquipmentSlot(hoveredSlot.method_7677())).method_5925() == class_1304.class_1305.field_6178) {
                int hoveredSlotId = ((ISlot)hoveredSlot).mouseWheelie_getIdInContainer();
                InteractionManager.pushClickEvent(this.field_2797.field_7763, hoveredSlotId, 0, class_1713.field_7790);
                InteractionManager.pushClickEvent(this.field_2797.field_7763, 8 - equipmentSlot.method_5927(), 0, class_1713.field_7790);
                InteractionManager.pushClickEvent(this.field_2797.field_7763, hoveredSlotId, 0, class_1713.field_7790);
                return ScrollAction.SUCCESS;
            }
            this.screenHelper.get().scroll(hoveredSlot, scrollAmount < 0.0);
            return ScrollAction.SUCCESS;
        }
        return ScrollAction.PASS;
    }

    @Unique
    private static class_1304 getEquipmentSlot(class_1799 stack) {
        class_10192 equippable = (class_10192)stack.method_57824(class_9334.field_54196);
        if (equippable != null) {
            return equippable.comp_3174();
        }
        return class_1304.field_6173;
    }

    @Override
    public boolean mouseWheelie_triggerSort() {
        if (this.field_2787 == null) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player.method_31549().field_7477 && GLFW.glfwGetMouseButton((long)this.field_22787.method_22683().method_4490(), (int)2) != 0 && !this.field_2787.method_7677().method_7960() == this.field_2797.method_34255().method_7960()) {
            return false;
        }
        InventorySorter sorter = new InventorySorter(this.screenHelper.get(), (class_465)this, this.field_2787);
        SortMode sortMode = MixinAbstractContainerScreen.method_25442() ? MouseWheelie.config.sort.shiftSort : (MixinAbstractContainerScreen.method_25441() ? MouseWheelie.config.sort.controlSort : MouseWheelie.config.sort.primarySort);
        if (sortMode == null) {
            return false;
        }
        sorter.sort(sortMode);
        return true;
    }
}

