/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.common.network;

import de.siphalor.mousewheelie.MouseWheelie;
import de.siphalor.mousewheelie.common.network.MWNetworking;
import de.siphalor.mousewheelie.common.network.PickFromInventoryPacket;
import de.siphalor.mousewheelie.common.network.ReorderInventoryPacket;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2735;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class MWLogicalServerNetworking
extends MWNetworking {
    @Generated
    private static final Logger log = MouseWheelie.createLogger(MWLogicalServerNetworking.class);

    private MWLogicalServerNetworking() {
    }

    public static void setup() {
        ServerPlayNetworking.registerGlobalReceiver(ReorderInventoryPacket.TYPE, (payload, context) -> MWLogicalServerNetworking.onReorderInventoryPacket(payload, context.server(), context.player()));
        ServerPlayNetworking.registerGlobalReceiver(PickFromInventoryPacket.TYPE, (payload, context) -> MWLogicalServerNetworking.onPickFromInventoryPacket(payload, (class_1657)context.player(), context.responseSender()));
    }

    private static void onReorderInventoryPacket(ReorderInventoryPacket packet, MinecraftServer server, class_3222 player) {
        if (packet == null) {
            log.warn("Failed to read reorder inventory packet from player {}!", (Object)player);
            return;
        }
        if (player.field_7512 == null) {
            log.warn("Player {} tried to reorder inventory without having an open container!", (Object)player);
            return;
        }
        if (packet.getSyncId() == player.field_7498.field_7763) {
            server.execute(() -> MWLogicalServerNetworking.reorder((class_1657)player, (class_1703)player.field_7498, packet.getSlotMappings()));
        } else if (packet.getSyncId() == player.field_7512.field_7763) {
            server.execute(() -> MWLogicalServerNetworking.reorder((class_1657)player, player.field_7512, packet.getSlotMappings()));
        }
    }

    private static void reorder(class_1657 player, class_1703 screenHandler, int[] slotMapping) {
        if (!MWLogicalServerNetworking.checkReorder(player, screenHandler, slotMapping)) {
            log.warn("Reorder inventory packet from player {} contains invalid data, ignoring!", (Object)player);
            return;
        }
        List stacks = screenHandler.field_7761.stream().map(class_1735::method_7677).collect(Collectors.toList());
        for (int i = 0; i < slotMapping.length; i += 2) {
            int originSlotId = slotMapping[i];
            int destSlotId = slotMapping[i + 1];
            ((class_1735)screenHandler.field_7761.get(destSlotId)).method_53512((class_1799)stacks.get(originSlotId));
        }
    }

    private static boolean checkReorder(class_1657 player, class_1703 screenHandler, int[] slotMappings) {
        int i;
        if (slotMappings.length < 4) {
            log.warn("Reorder inventory packet contains too few slots!");
            return false;
        }
        IntAVLTreeSet requestedSlots = new IntAVLTreeSet();
        class_1735 firstSlot = (class_1735)screenHandler.field_7761.get(slotMappings[0]);
        class_1263 targetInv = firstSlot.field_7871;
        for (i = 0; i < slotMappings.length; i += 2) {
            int originSlotId = slotMappings[i];
            int destSlotId = slotMappings[i + 1];
            if (!MWLogicalServerNetworking.checkReorderSlot(screenHandler, originSlotId, targetInv)) {
                return false;
            }
            if (!requestedSlots.add(originSlotId)) {
                log.warn("Reorder inventory packet contains duplicate origin slot {}!", (Object)originSlotId);
                return false;
            }
            if (!MWLogicalServerNetworking.checkReorderSlot(screenHandler, destSlotId, targetInv)) {
                return false;
            }
            if (originSlotId == destSlotId) continue;
            class_1735 originSlot = screenHandler.method_7611(originSlotId);
            if (!originSlot.method_7674(player)) {
                log.warn("Player {} tried to reorder slot {}, but that slot doesn't allow taking items!", (Object)player, (Object)originSlotId);
                return false;
            }
            class_1735 destSlot = screenHandler.method_7611(destSlotId);
            if (destSlot.method_7680(originSlot.method_7677())) continue;
            log.warn("Player {} tried to reorder slot {}, but that slot doesn't allow inserting the origin stack!", (Object)player, (Object)destSlotId);
            return false;
        }
        for (i = 1; i < slotMappings.length; i += 2) {
            int destSlotId = slotMappings[i];
            if (requestedSlots.remove(destSlotId)) continue;
            log.warn("Reorder inventory packet contains duplicate destination slot or slot without origin: {}!", (Object)i);
            return false;
        }
        if (!requestedSlots.isEmpty()) {
            log.error("Invalid state during checking reorder packet, please report this to the {} bug tracker. Requested slots: {}", (Object)"Mouse Wheelie", (Object)requestedSlots);
            return false;
        }
        return true;
    }

    private static boolean checkReorderSlot(class_1703 screenHandler, int slotId, class_1263 targetInv) {
        class_1735 slot = screenHandler.method_7611(slotId);
        if (slot == null) {
            log.warn("Reorder inventory packet contains invalid slot id!");
            return false;
        }
        if (targetInv != slot.field_7871) {
            log.warn("Reorder inventory packet contains slots from different inventories, first: {}, now: {}!", (Object)targetInv, (Object)slot.field_7871);
            return false;
        }
        return true;
    }

    private static void onPickFromInventoryPacket(PickFromInventoryPacket packet, class_1657 player, PacketSender sender) {
        class_1661 inventory = player.method_31548();
        inventory.method_7365(packet.slot());
        int selected = inventory.field_7545;
        sender.sendPacket((class_2596)inventory.method_61497(selected));
        sender.sendPacket((class_2596)inventory.method_61497(packet.slot()));
        sender.sendPacket((class_2596)new class_2735(selected));
    }
}

