/*
 * Decompiled with CFR 0.152.
 */
package com.ishikyoo.memora.api;

import com.ishikyoo.memora.api.InMemoryPackMetadata;
import com.ishikyoo.memora.api.asset.InMemoryAsset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public final class InMemoryPack {
    @NotNull
    private final InMemoryPackMetadata metadata;
    @NotNull
    private final Map<class_2960, InMemoryAsset> assets;

    private InMemoryPack(@NotNull InMemoryPackMetadata metadata, @NotNull Map<class_2960, InMemoryAsset> assets) {
        this.metadata = metadata;
        this.assets = Collections.unmodifiableMap(assets);
    }

    public static InMemoryPack of(@NotNull InMemoryPackMetadata metadata) {
        return new InMemoryPack(metadata, new HashMap<class_2960, InMemoryAsset>()).withAsset(metadata.asset());
    }

    @NotNull
    public InMemoryPackMetadata metadata() {
        return this.metadata;
    }

    @NotNull
    public InMemoryPack withAsset(@NotNull InMemoryAsset asset) {
        if (this.assets.containsKey(Objects.requireNonNull(asset.location())) && this.assets.containsValue(asset)) {
            return this;
        }
        HashMap<class_2960, InMemoryAsset> assets = new HashMap<class_2960, InMemoryAsset>(this.assets);
        assets.put(asset.location(), asset);
        return new InMemoryPack(this.metadata, assets);
    }

    @NotNull
    public InMemoryPack withoutAsset(@NotNull class_2960 location) {
        if (!this.assets.containsKey(Objects.requireNonNull(location))) {
            return this;
        }
        HashMap<class_2960, InMemoryAsset> assets = new HashMap<class_2960, InMemoryAsset>(this.assets);
        assets.remove(location);
        return new InMemoryPack(this.metadata, assets);
    }

    @NotNull
    public InMemoryPack withoutAsset(@NotNull InMemoryAsset asset) {
        return this.withoutAsset(asset.location());
    }

    @NotNull
    public <T extends InMemoryAsset> Optional<T> asset(@NotNull class_2960 location, @NotNull Class<T> type) {
        InMemoryAsset asset = this.assets.get(Objects.requireNonNull(location));
        if (asset == null) {
            return Optional.empty();
        }
        if (asset.getClass() != Objects.requireNonNull(type)) {
            return Optional.empty();
        }
        return Optional.of((InMemoryAsset)type.cast(asset));
    }

    @NotNull
    public Optional<InMemoryAsset> asset(@NotNull class_2960 location) {
        return Optional.ofNullable(this.assets.get(Objects.requireNonNull(location)));
    }

    @NotNull
    public Collection<InMemoryAsset> assets() {
        return Collections.unmodifiableCollection(this.assets.values());
    }
}

