/*
 * Decompiled with CFR 0.152.
 */
package com.ishikyoo.memora.api;

import com.ishikyoo.memora.api.asset.InMemoryPackMetadataAsset;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1077;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5352;
import net.minecraft.class_7085;
import net.minecraft.class_9225;
import org.jetbrains.annotations.NotNull;

public final class InMemoryPackMetadata {
    @NotNull
    private final String id;
    @NotNull
    private final class_2561 title;
    @NotNull
    private final class_5352 source;
    @NotNull
    private final class_9225 config;
    @NotNull
    private final InMemoryPackMetadataAsset asset;

    private InMemoryPackMetadata(@NotNull String id, @NotNull class_2561 title, @NotNull class_5352 source, @NotNull class_9225 config, @NotNull InMemoryPackMetadataAsset asset) {
        this.id = id;
        this.title = title;
        this.source = source;
        this.config = config;
        this.asset = asset;
    }

    @NotNull
    public static InMemoryPackMetadata of(@NotNull String id, @NotNull class_3264 type, @NotNull class_5352 source, @NotNull class_9225 config, @NotNull class_2561 title, @NotNull class_2561 description) {
        InMemoryPackMetadataAsset internal = InMemoryPackMetadataAsset.of(Objects.requireNonNull(type), Objects.requireNonNull(description));
        return new InMemoryPackMetadata(Objects.requireNonNull(id), Objects.requireNonNull(title), Objects.requireNonNull(source), Objects.requireNonNull(config), internal);
    }

    @NotNull
    public String id() {
        return this.id;
    }

    @NotNull
    public class_3264 type() {
        return this.asset.type();
    }

    @NotNull
    public class_5352 source() {
        return this.source;
    }

    @NotNull
    public class_9225 config() {
        return this.config;
    }

    @NotNull
    public class_2561 title() {
        return this.title;
    }

    @NotNull
    public class_2561 description() {
        return this.asset.description();
    }

    @NotNull
    public InMemoryPackMetadataAsset asset() {
        return this.asset;
    }

    @NotNull
    public Collection<class_7085> filters() {
        return this.asset.filters();
    }

    @NotNull
    public Collection<class_1077> languages() {
        return this.asset.languages();
    }

    public InMemoryPackMetadata withId(@NotNull String id) {
        return new InMemoryPackMetadata(Objects.requireNonNull(id), this.title, this.source, this.config, this.asset);
    }

    public InMemoryPackMetadata withTitle(@NotNull class_2561 title) {
        return new InMemoryPackMetadata(this.id, Objects.requireNonNull(title), this.source, this.config, this.asset);
    }

    @NotNull
    public InMemoryPackMetadata withType(@NotNull class_3264 type) {
        return new InMemoryPackMetadata(this.id, this.title, this.source, this.config, this.asset.withType(Objects.requireNonNull(type)));
    }

    @NotNull
    public InMemoryPackMetadata withSource(@NotNull class_5352 source) {
        return new InMemoryPackMetadata(this.id, this.title, Objects.requireNonNull(source), this.config, this.asset);
    }

    @NotNull
    public InMemoryPackMetadata withConfig(@NotNull class_9225 config) {
        return new InMemoryPackMetadata(this.id, this.title, this.source, Objects.requireNonNull(config), this.asset);
    }

    @NotNull
    public InMemoryPackMetadata withDescription(class_2561 description) {
        return new InMemoryPackMetadata(this.id, this.title, this.source, this.config, this.asset.withDescription(Objects.requireNonNull(description)));
    }

    @NotNull
    public InMemoryPackMetadata withFeature(@NotNull class_2960 feature) {
        return new InMemoryPackMetadata(this.id, this.title, this.source, this.config, this.asset.withFeature(Objects.requireNonNull(feature)));
    }

    @NotNull
    public InMemoryPackMetadata withFilter(@NotNull class_7085 pattern) {
        return new InMemoryPackMetadata(this.id, this.title, this.source, this.config, this.asset.withFilter(Objects.requireNonNull(pattern)));
    }

    @NotNull
    public InMemoryPackMetadata withLanguage(@NotNull String code, @NotNull class_1077 info) {
        return new InMemoryPackMetadata(this.id, this.title, this.source, this.config, this.asset.withLanguage(Objects.requireNonNull(code), Objects.requireNonNull(info)));
    }
}

