/*
 * Decompiled with CFR 0.152.
 */
package com.ishikyoo.memora.api;

import com.ishikyoo.memora.api.InMemoryPack;
import com.ishikyoo.memora.api.asset.InMemoryAsset;
import com.ishikyoo.memora.internal.Memora;
import com.ishikyoo.memora.internal.ModContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_9224;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class InMemoryPackRepository {
    private static final Logger LOGGER = ModContext.LOGGER;
    private final Map<String, InMemoryPack> packs = new HashMap<String, InMemoryPack>();

    @NotNull
    public Optional<InMemoryPack> addPack(@NotNull InMemoryPack pack) {
        Objects.requireNonNull(pack);
        if (this.packs.containsKey(pack.metadata().id())) {
            LOGGER.warn("In-memory pack already exists in repository: {}", (Object)pack.metadata().id());
            return Optional.empty();
        }
        this.packs.put(pack.metadata().id(), pack);
        com.ishikyoo.memora.internal.InMemoryPack internal = new com.ishikyoo.memora.internal.InMemoryPack(pack.metadata().type(), new class_9224(pack.metadata().id(), pack.metadata().title(), pack.metadata().source(), Optional.empty()), pack.metadata().config());
        for (InMemoryAsset asset : pack.assets()) {
            byte[] buffer = asset.bytes();
            internal.addResource(asset.location(), buffer);
        }
        internal.create();
        Memora.repository.addPack(internal);
        return Optional.of(pack);
    }

    @NotNull
    public Optional<InMemoryPack> removePack(@NotNull String id) {
        Objects.requireNonNull(id);
        InMemoryPack removed = this.packs.remove(id);
        if (removed == null) {
            LOGGER.warn("Attempted to remove non-existent in-memory pack: {}", (Object)id);
            return Optional.empty();
        }
        Memora.repository.removePack(id);
        return Optional.of(removed);
    }

    @NotNull
    public Optional<InMemoryPack> getPack(@NotNull String id) {
        Objects.requireNonNull(id);
        return Optional.ofNullable(this.packs.get(id));
    }

    @NotNull
    public Collection<InMemoryPack> getPacks() {
        return Collections.unmodifiableCollection(this.packs.values());
    }
}

