/*
 * Decompiled with CFR 0.152.
 */
package com.ishikyoo.memora.api.asset;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InMemoryAsset {
    @NotNull
    protected final Key key;
    @Nullable
    private class_2960 location;
    protected byte @Nullable [] bytes;

    protected InMemoryAsset(@NotNull Key key, byte @Nullable [] bytes) {
        this.key = key;
        this.bytes = bytes;
    }

    @NotNull
    public Key key() {
        return this.key;
    }

    @NotNull
    public class_2960 location() {
        if (this.location == null) {
            this.location = this.key.location();
        }
        return this.location;
    }

    public byte @NotNull [] bytes() {
        try {
            if (this.bytes == null) {
                this.bytes = this.toBytes();
            }
            return this.bytes;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert asset to bytes: type=" + String.valueOf(this.key()), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InMemoryAsset)) {
            return false;
        }
        InMemoryAsset that = (InMemoryAsset)o;
        return this.key.equals(that.key) && Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        int result = Objects.hash(this.key);
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public String toString() {
        return "InMemoryAsset{key=" + String.valueOf(this.key) + ", bytes=" + (String)(this.bytes == null ? "null" : this.bytes.length + " bytes") + "}";
    }

    protected abstract byte @NotNull [] toBytes();

    public static class Key {
        public static final String PATH_SEPARATOR = "/";
        public static final String SUFFIX_SEPARATOR = ".";
        @NotNull
        String namespace;
        @NotNull
        String prefix;
        @NotNull
        String name;
        @NotNull
        String suffix;

        private Key(@NotNull String namespace, @NotNull String prefix, @NotNull String name, @NotNull String suffix) {
            this.namespace = namespace;
            this.prefix = prefix;
            this.name = name;
            this.suffix = suffix;
        }

        @NotNull
        public class_2960 location() {
            return class_2960.method_60655((String)this.namespace, (String)((String)(this.prefix.isEmpty() ? "" : this.prefix + PATH_SEPARATOR) + String.join((CharSequence)SUFFIX_SEPARATOR, this.name, this.suffix)));
        }

        @NotNull
        public static Key of(@NotNull String namespace, @NotNull String prefix, @NotNull String name, @NotNull String suffix) {
            Key.assertValidNamespace(namespace);
            Key.assertValidPrefix(prefix);
            Key.assertValidName(name);
            Key.assertValidSuffix(suffix);
            return new Key(namespace, prefix, name, suffix);
        }

        @NotNull
        public static Key of(@NotNull class_2960 location) {
            String path = location.method_12832();
            int lastSlash = path.lastIndexOf(PATH_SEPARATOR);
            String prefix = lastSlash == -1 ? "" : path.substring(0, lastSlash);
            String filename = lastSlash == -1 ? path : path.substring(lastSlash + 1);
            int lastDot = filename.lastIndexOf(SUFFIX_SEPARATOR);
            String name = filename.substring(0, lastDot);
            String suffix = filename.substring(lastDot + 1);
            return new Key(location.method_12836(), prefix, name, suffix);
        }

        @NotNull
        public Key withNamespace(@NotNull String namespace) {
            return new Key(Key.assertValidNamespace(namespace), this.prefix, this.name, this.suffix);
        }

        @NotNull
        public Key withPrefix(@NotNull String prefix) {
            return new Key(this.namespace, Key.assertValidPrefix(prefix), this.name, this.suffix);
        }

        @NotNull
        public Key withName(@NotNull String name) {
            return new Key(this.namespace, this.prefix, Key.assertValidName(name), this.suffix);
        }

        @NotNull
        public Key withSuffix(@NotNull String suffix) {
            return new Key(this.namespace, this.prefix, this.name, Key.assertValidSuffix(suffix));
        }

        @NotNull
        public String namespace() {
            return this.namespace;
        }

        @NotNull
        public String prefix() {
            return this.prefix;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public String suffix() {
            return this.suffix;
        }

        public static boolean isValidNamespace(@NotNull String namespace) {
            return class_2960.method_20209((String)namespace);
        }

        public static boolean isValidName(@NotNull String name) {
            return class_2960.method_20209((String)name);
        }

        public static boolean isValidPrefix(@NotNull String prefix) {
            return class_2960.method_20208((String)prefix);
        }

        public static boolean isValidSuffix(@NotNull String suffix) {
            return class_2960.method_20209((String)suffix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return this.namespace.equals(key.namespace) && this.prefix.equals(key.prefix) && this.name.equals(key.name) && this.suffix.equals(key.suffix);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.prefix, this.name, this.suffix);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.namespace).append(':');
            if (!this.prefix.isEmpty()) {
                sb.append(this.prefix).append(PATH_SEPARATOR);
            }
            sb.append(this.name).append(SUFFIX_SEPARATOR).append(this.suffix);
            return sb.toString();
        }

        @NotNull
        private static String assertValidNamespace(@NotNull String namespace) {
            if (!Key.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("In-memory asset key namespace must be [a-z0-9._-], but was: " + namespace);
            }
            return namespace;
        }

        @NotNull
        private static String assertValidName(@NotNull String name) {
            if (!Key.isValidName(name)) {
                throw new IllegalArgumentException("In-memory asset key name must be [a-z0-9._-], but was: " + name);
            }
            return name;
        }

        @NotNull
        private static String assertValidPrefix(@NotNull String prefix) {
            if (!Key.isValidPrefix(prefix)) {
                throw new IllegalArgumentException("In-memory asset key prefix must be path-like ([a-z0-9._-]/...), but was: " + prefix);
            }
            return prefix;
        }

        @NotNull
        private static String assertValidSuffix(@NotNull String suffix) {
            if (!Key.isValidSuffix(suffix)) {
                throw new IllegalArgumentException("In-Memory asset key suffix must be [a-z0-9._-], but was: " + suffix);
            }
            return suffix;
        }
    }
}

