/*
 * Decompiled with CFR 0.152.
 */
package com.ishikyoo.memora.api.asset;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ishikyoo.memora.api.asset.InMemoryAsset;
import com.ishikyoo.memora.api.asset.InMemoryJSONAsset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InMemoryBlockStateAsset
extends InMemoryJSONAsset {
    @NotNull
    private final Map<String, Variant> variants;
    @NotNull
    private final Set<Multipart> multipart;

    private InMemoryBlockStateAsset(@NotNull InMemoryAsset.Key key, @NotNull Map<String, Variant> variants, @NotNull Set<Multipart> multipart) {
        super(key);
        this.variants = Collections.unmodifiableMap(variants);
        this.multipart = Collections.unmodifiableSet(multipart);
    }

    @NotNull
    public static InMemoryBlockStateAsset of(@NotNull class_2960 location) {
        Objects.requireNonNull(location);
        return InMemoryBlockStateAsset.of(location.method_12836(), location.method_12832());
    }

    @NotNull
    public static InMemoryBlockStateAsset of(@NotNull String namespace, @NotNull String name) {
        InMemoryAsset.Key key = InMemoryAsset.Key.of(Objects.requireNonNull(namespace), "blockstates", Objects.requireNonNull(name), "json");
        return new InMemoryBlockStateAsset(key, new LinkedHashMap<String, Variant>(), new LinkedHashSet<Multipart>());
    }

    @NotNull
    public InMemoryBlockStateAsset withVariant(@NotNull String key, @NotNull Variant variant) {
        if (this.variants.containsKey(Objects.requireNonNull(key)) && this.variants.containsValue(Objects.requireNonNull(variant))) {
            return this;
        }
        LinkedHashMap<String, Variant> copy = new LinkedHashMap<String, Variant>(this.variants);
        copy.put(key, variant);
        return new InMemoryBlockStateAsset(this.key(), copy, new LinkedHashSet<Multipart>());
    }

    @NotNull
    public InMemoryBlockStateAsset withMultipart(@NotNull Multipart multipart) {
        if (this.multipart.contains(multipart)) {
            return this;
        }
        LinkedHashSet<Multipart> copy = new LinkedHashSet<Multipart>(this.multipart);
        copy.add(multipart);
        return new InMemoryBlockStateAsset(this.key(), new LinkedHashMap<String, Variant>(), copy);
    }

    @Override
    @NotNull
    protected JsonElement toJson() {
        JsonObject root = new JsonObject();
        if (!this.variants.isEmpty()) {
            JsonObject v = new JsonObject();
            this.variants.forEach((k, variant) -> v.add(k, variant.toJson()));
            root.add("variants", (JsonElement)v);
        }
        if (!this.multipart.isEmpty()) {
            JsonArray parts = new JsonArray();
            this.multipart.forEach(m -> parts.add(m.toJson()));
            root.add("multipart", (JsonElement)parts);
        }
        return root;
    }

    public static class Multipart {
        @Nullable
        private final Condition when;
        @NotNull
        private final Set<Model> apply;

        private Multipart(@Nullable Condition when, @NotNull Set<Model> apply) {
            this.when = when;
            this.apply = Collections.unmodifiableSet(apply);
        }

        @NotNull
        public static Multipart of(@Nullable Condition when, @NotNull Model apply) {
            return new Multipart(when, Collections.singleton(Objects.requireNonNull(apply)));
        }

        @NotNull
        public static Multipart of(@Nullable Condition when, @NotNull Collection<Model> apply) {
            Objects.requireNonNull(apply);
            return new Multipart(when, new LinkedHashSet<Model>(apply));
        }

        @NotNull
        public Multipart withWhen(@Nullable Condition when) {
            if (Objects.equals(when, this.when)) {
                return this;
            }
            return new Multipart(when, this.apply);
        }

        @NotNull
        public Multipart withApply(@NotNull Model model) {
            Objects.requireNonNull(model);
            if (this.apply.size() == 1 && this.apply.iterator().next().equals(model)) {
                return this;
            }
            return new Multipart(this.when, Collections.singleton(model));
        }

        @NotNull
        public Multipart withApply(@NotNull Collection<Model> models) {
            Objects.requireNonNull(models);
            if (new LinkedHashSet<Model>(models).equals(this.apply)) {
                return this;
            }
            return new Multipart(this.when, new LinkedHashSet<Model>(models));
        }

        @NotNull
        public Multipart withoutWhen() {
            if (this.when == null) {
                return this;
            }
            return new Multipart(null, this.apply);
        }

        JsonElement toJson() {
            JsonObject o = new JsonObject();
            if (this.when != null) {
                o.add("when", this.when.toJson());
            }
            if (this.apply.size() == 1) {
                o.add("apply", this.apply.iterator().next().toJson());
            } else {
                JsonArray arr = new JsonArray();
                this.apply.forEach(m -> arr.add(m.toJson()));
                o.add("apply", (JsonElement)arr);
            }
            return o;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Multipart)) {
                return false;
            }
            Multipart that = (Multipart)o;
            return Objects.equals(this.when, that.when) && this.apply.equals(that.apply);
        }

        public int hashCode() {
            return Objects.hash(this.when, this.apply);
        }

        public String toString() {
            return "Multipart[when=" + String.valueOf(this.when) + ", apply=" + String.valueOf(this.apply) + "]";
        }
    }

    public static class Variant {
        @NotNull
        private final Set<Model> models;

        private Variant(@NotNull Set<Model> models) {
            this.models = Collections.unmodifiableSet(new LinkedHashSet<Model>(models));
        }

        public static Variant of(@NotNull Model model) {
            Objects.requireNonNull(model);
            return new Variant(Collections.singleton(model));
        }

        public static Variant of(@NotNull Collection<Model> models) {
            Objects.requireNonNull(models);
            return new Variant(new LinkedHashSet<Model>(models));
        }

        JsonElement toJson() {
            if (this.models.size() == 1) {
                return this.models.iterator().next().toJson();
            }
            JsonArray arr = new JsonArray();
            this.models.forEach(m -> arr.add(m.toJson()));
            return arr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Variant)) {
                return false;
            }
            Variant v = (Variant)o;
            return this.models.equals(v.models);
        }

        public int hashCode() {
            return Objects.hash(this.models);
        }

        public String toString() {
            return "Variant" + String.valueOf(this.models);
        }
    }

    public static class CompositeCondition
    implements Condition {
        @NotNull
        private final String op;
        @NotNull
        private final Set<Condition> children;

        private CompositeCondition(@NotNull String op, @NotNull Set<Condition> children) {
            this.op = Objects.requireNonNull(op);
            this.children = Collections.unmodifiableSet(new LinkedHashSet<Condition>(children));
        }

        public static CompositeCondition and(@NotNull Collection<Condition> children) {
            return new CompositeCondition("and", new LinkedHashSet<Condition>(children));
        }

        public static CompositeCondition or(@NotNull Collection<Condition> children) {
            return new CompositeCondition("or", new LinkedHashSet<Condition>(children));
        }

        @Override
        public JsonElement toJson() {
            JsonObject o = new JsonObject();
            JsonArray arr = new JsonArray();
            this.children.forEach(c -> arr.add(c.toJson()));
            o.add(this.op, (JsonElement)arr);
            return o;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompositeCondition)) {
                return false;
            }
            CompositeCondition that = (CompositeCondition)o;
            return this.op.equals(that.op) && this.children.equals(that.children);
        }

        public int hashCode() {
            return Objects.hash(this.op, this.children);
        }

        public String toString() {
            return "CompositeCondition[" + this.op + " " + String.valueOf(this.children) + "]";
        }
    }

    public static class PropertyCondition
    implements Condition {
        @NotNull
        private final String key;
        @NotNull
        private final Set<String> values;

        public PropertyCondition(@NotNull String key, @NotNull Set<String> values) {
            this.key = Objects.requireNonNull(key);
            this.values = Collections.unmodifiableSet(new LinkedHashSet(Objects.requireNonNull(values)));
        }

        @Override
        public JsonElement toJson() {
            JsonObject o = new JsonObject();
            if (this.values.size() == 1) {
                o.addProperty(this.key, this.values.iterator().next());
            } else {
                JsonArray arr = new JsonArray();
                this.values.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
                o.add(this.key, (JsonElement)arr);
            }
            return o;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyCondition)) {
                return false;
            }
            PropertyCondition that = (PropertyCondition)o;
            return this.key.equals(that.key) && this.values.equals(that.values);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.values);
        }

        public String toString() {
            return "PropertyCondition[" + this.key + "=" + String.valueOf(this.values) + "]";
        }
    }

    public static interface Condition {
        public JsonElement toJson();
    }

    public static class Model {
        @NotNull
        private final class_2960 path;
        private final int x;
        private final int y;
        private final int weight;
        private final boolean uvlock;

        private Model(@NotNull class_2960 path, int x, int y, boolean uvlock, int weight) {
            if (weight < 1) {
                throw new IllegalArgumentException("Weight must be >= 1");
            }
            this.path = path;
            this.x = x;
            this.y = y;
            this.uvlock = uvlock;
            this.weight = weight;
        }

        @NotNull
        public static Model of(@NotNull class_2960 path) {
            return new Model(Objects.requireNonNull(path), 0, 0, false, 1);
        }

        @NotNull
        public Model withPath(@NotNull class_2960 path) {
            if (Objects.requireNonNull(path).equals((Object)this.path)) {
                return this;
            }
            return new Model(path, this.x, this.y, this.uvlock, this.weight);
        }

        @NotNull
        public Model withX(int degrees) {
            int clampDegrees = Model.clampDegrees(degrees);
            if (clampDegrees == this.x) {
                return this;
            }
            return new Model(this.path, clampDegrees, this.y, this.uvlock, this.weight);
        }

        @NotNull
        public Model withY(int degrees) {
            int clampDegrees = Model.clampDegrees(degrees);
            if (clampDegrees == this.y) {
                return this;
            }
            return new Model(this.path, this.x, clampDegrees, this.uvlock, this.weight);
        }

        @NotNull
        public Model withUVLock(boolean uvlock) {
            if (uvlock == this.uvlock) {
                return this;
            }
            return new Model(this.path, this.x, this.y, uvlock, this.weight);
        }

        @NotNull
        public Model withWeight(int weight) {
            if (weight == this.weight) {
                return this;
            }
            return new Model(this.path, this.x, this.y, this.uvlock, weight);
        }

        @NotNull
        public class_2960 path() {
            return this.path;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int weight() {
            return this.weight;
        }

        public boolean uvlock() {
            return this.uvlock;
        }

        JsonElement toJson() {
            JsonObject o = new JsonObject();
            o.addProperty("model", this.path.toString());
            if (this.x != 0) {
                o.addProperty("x", (Number)this.x);
            }
            if (this.y != 0) {
                o.addProperty("y", (Number)this.y);
            }
            if (this.uvlock) {
                o.addProperty("uvlock", Boolean.valueOf(true));
            }
            if (this.weight != 1) {
                o.addProperty("weight", (Number)this.weight);
            }
            return o;
        }

        private static int clampDegrees(int degrees) {
            int normalized = (degrees % 360 + 360) % 360;
            return Math.round((float)normalized / 90.0f) * 90 % 360;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Model)) {
                return false;
            }
            Model model = (Model)o;
            return this.x == model.x && this.y == model.y && this.weight == model.weight && this.uvlock == model.uvlock && this.path.equals((Object)model.path);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.x, this.y, this.uvlock, this.weight);
        }

        public String toString() {
            return "Model[" + String.valueOf(this.path) + ", x=" + this.x + ", y=" + this.y + ", uvlock=" + this.uvlock + ", weight=" + this.weight + "]";
        }
    }
}

