/*
 * Decompiled with CFR 0.152.
 */
package com.ishikyoo.memora.api.asset;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.ishikyoo.memora.api.asset.InMemoryAsset;
import com.ishikyoo.memora.api.asset.InMemoryTextAsset;
import org.jetbrains.annotations.NotNull;

public abstract class InMemoryJSONAsset
extends InMemoryTextAsset {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    protected InMemoryJSONAsset(@NotNull InMemoryAsset.Key key) {
        super(key);
    }

    @NotNull
    protected abstract JsonElement toJson();

    @Override
    @NotNull
    protected String toText() {
        try {
            JsonElement json = this.toJson();
            return GSON.toJson(json);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to serialize JSON asset: " + String.valueOf(this.key()), e);
        }
    }
}

