/*
 * Decompiled with CFR 0.152.
 */
package com.ishikyoo.memora.api.asset;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ishikyoo.memora.api.asset.InMemoryAsset;
import com.ishikyoo.memora.api.asset.InMemoryJSONAsset;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1077;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_7084;
import net.minecraft.class_7085;
import net.minecraft.class_8617;
import org.jetbrains.annotations.NotNull;

public final class InMemoryPackMetadataAsset
extends InMemoryJSONAsset {
    @NotNull
    private final class_3272 metadata;
    @NotNull
    private final class_3264 type;
    @NotNull
    private final Set<class_2960> features;
    @NotNull
    private final Set<class_7085> filters;
    @NotNull
    private final Set<class_8617.class_8618> overlays;
    @NotNull
    private final Map<String, class_1077> languages;

    private InMemoryPackMetadataAsset(@NotNull InMemoryAsset.Key key, @NotNull class_3264 type, @NotNull Set<class_2960> features, @NotNull class_3272 metadata, @NotNull Set<class_7085> filters, @NotNull Set<class_8617.class_8618> overlays, @NotNull Map<String, class_1077> languages) {
        super(key);
        this.type = type;
        this.features = features;
        this.metadata = metadata;
        this.filters = Collections.unmodifiableSet(filters);
        this.overlays = Collections.unmodifiableSet(overlays);
        this.languages = Collections.unmodifiableMap(languages);
    }

    @NotNull
    public static InMemoryPackMetadataAsset of(@NotNull class_3264 type, @NotNull class_2561 description) {
        InMemoryAsset.Key key = InMemoryAsset.Key.of("root", "", "pack", "mcmeta");
        class_3272 metadata = new class_3272(description, class_155.method_16673().method_70592(type), Optional.empty());
        return new InMemoryPackMetadataAsset(key, type, new HashSet<class_2960>(), metadata, new HashSet<class_7085>(), new HashSet<class_8617.class_8618>(), new HashMap<String, class_1077>());
    }

    @NotNull
    public class_3264 type() {
        return this.type;
    }

    @NotNull
    public class_2561 description() {
        return this.metadata.comp_1580();
    }

    @NotNull
    public Collection<class_7085> filters() {
        return this.filters;
    }

    @NotNull
    public Collection<class_1077> languages() {
        return Collections.unmodifiableCollection(this.languages.values());
    }

    @NotNull
    public InMemoryPackMetadataAsset withType(@NotNull class_3264 type) {
        if (type.equals((Object)this.type)) {
            return this;
        }
        class_3272 metadata = new class_3272(this.metadata.comp_1580(), class_155.method_16673().method_70592(type), Optional.empty());
        return new InMemoryPackMetadataAsset(this.key, type, this.features, metadata, this.filters, this.overlays, this.languages);
    }

    @NotNull
    public InMemoryPackMetadataAsset withFeature(@NotNull class_2960 feature) {
        if (this.features.contains(feature)) {
            return this;
        }
        HashSet<class_2960> features = new HashSet<class_2960>(this.features);
        features.add(feature);
        return new InMemoryPackMetadataAsset(this.key, this.type, features, this.metadata, this.filters, this.overlays, this.languages);
    }

    public InMemoryPackMetadataAsset withDescription(class_2561 description) {
        if (this.metadata.comp_1580().equals((Object)description)) {
            return this;
        }
        return new InMemoryPackMetadataAsset(this.key(), this.type, this.features, new class_3272(description, this.metadata.comp_1581(), this.metadata.comp_1582()), this.filters, this.overlays, this.languages);
    }

    public InMemoryPackMetadataAsset withFilter(@NotNull class_7085 pattern) {
        if (this.filters.contains(pattern)) {
            return this;
        }
        HashSet<class_7085> filters = new HashSet<class_7085>(this.filters);
        filters.add(pattern);
        return new InMemoryPackMetadataAsset(this.key, this.type, this.features, this.metadata, filters, this.overlays, this.languages);
    }

    public InMemoryPackMetadataAsset withLanguage(@NotNull String code, @NotNull class_1077 info) {
        if (!this.languages.containsKey(code) && !this.languages.containsValue(info)) {
            return this;
        }
        HashMap<String, class_1077> languages = new HashMap<String, class_1077>(this.languages);
        languages.put(code, info);
        return new InMemoryPackMetadataAsset(this.key, this.type, this.features, this.metadata, this.filters, this.overlays, languages);
    }

    @Override
    @NotNull
    protected JsonElement toJson() {
        Optional<JsonElement> optionalEncodedPackSection = InMemoryPackMetadataAsset.encodePackSection(this.metadata);
        Optional<JsonElement> optionalFeaturesSection = InMemoryPackMetadataAsset.encodeFeaturesSection(this.features);
        class_7084 filterSection = new class_7084(this.filters.stream().toList());
        Optional<JsonElement> optionalEncodedFiltersSection = InMemoryPackMetadataAsset.encodeFilterSection(filterSection);
        class_8617 overlayMetadataSection = new class_8617(this.overlays.stream().toList());
        Optional<JsonElement> optionalOverlayMetadataSection = InMemoryPackMetadataAsset.encodeOverlayMetadataSection(overlayMetadataSection);
        Optional<JsonElement> optionalLanguagesSection = InMemoryPackMetadataAsset.encodeLanguagesSection(this.languages);
        JsonObject root = new JsonObject();
        optionalEncodedPackSection.ifPresent(jsonElement -> root.add("pack", jsonElement));
        optionalFeaturesSection.ifPresent(jsonElement -> root.add("features", jsonElement));
        optionalEncodedFiltersSection.ifPresent(jsonElement -> root.add("filter", jsonElement));
        optionalOverlayMetadataSection.ifPresent(jsonElement -> root.add("overlays", jsonElement));
        optionalLanguagesSection.ifPresent(jsonElement -> root.add("language", jsonElement));
        return root;
    }

    private static Optional<JsonElement> encodePackSection(class_3272 section) {
        DataResult encoded = class_3272.field_45051.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)section);
        return encoded.resultOrPartial(error -> {
            throw new IllegalStateException("Failed to encode pack metadata section: " + error);
        });
    }

    private static Optional<JsonElement> encodeFeaturesSection(Set<class_2960> features) {
        if (features.isEmpty()) {
            return Optional.empty();
        }
        JsonObject obj = new JsonObject();
        JsonArray array = new JsonArray();
        for (class_2960 feature : features) {
            array.add(feature.toString());
        }
        obj.add("enabled", (JsonElement)array);
        return Optional.of(obj);
    }

    private static Optional<JsonElement> encodeFilterSection(class_7084 section) {
        DataResult encoded = class_7084.field_40055.comp_3437().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)section);
        return encoded.resultOrPartial(error -> {
            throw new IllegalStateException("Failed to encode resource filter section: " + error);
        });
    }

    private static Optional<JsonElement> encodeOverlayMetadataSection(class_8617 section) {
        DataResult encoded = class_8617.field_45045.comp_3437().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)section);
        return encoded.resultOrPartial(error -> {
            throw new IllegalStateException("Failed to encode overlays metadata section: " + error);
        });
    }

    private static Optional<JsonElement> encodeLanguagesSection(Map<String, class_1077> languages) {
        if (languages.isEmpty()) {
            return Optional.empty();
        }
        UnboundedMapCodec codec = Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_1077.field_41862);
        DataResult encoded = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, languages);
        return encoded.resultOrPartial(error -> {
            throw new IllegalStateException("Failed to encode languages section: " + error);
        });
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InMemoryPackMetadataAsset)) {
            return false;
        }
        InMemoryPackMetadataAsset that = (InMemoryPackMetadataAsset)o;
        return Objects.equals(this.key(), that.key()) && this.type == that.type && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.features, that.features) && Objects.equals(this.filters, that.filters) && Objects.equals(this.overlays, that.overlays) && Objects.equals(this.languages, that.languages);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key(), this.type, this.metadata, this.features, this.filters, this.overlays, this.languages);
    }

    @Override
    public String toString() {
        return "InMemoryPackMetadataAsset[key=" + String.valueOf(this.key()) + ", type=" + String.valueOf(this.type) + ", metadata=" + String.valueOf(this.metadata) + ", features=" + String.valueOf(this.features) + ", filters=" + String.valueOf(this.filters) + ", overlays=" + String.valueOf(this.overlays) + ", languages=" + String.valueOf(this.languages) + "]";
    }
}

