/*
 * Decompiled with CFR 0.152.
 */
package com.ishikyoo.memora.internal;

import com.ishikyoo.memora.internal.InMemoryPackResources;
import com.ishikyoo.memora.internal.InMemoryResource;
import com.ishikyoo.memora.internal.ModContext;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class InMemoryPack {
    private static final Logger LOGGER = ModContext.LOGGER;
    @NotNull
    private final class_3264 type;
    @NotNull
    private final class_9224 location;
    @NotNull
    private final InMemoryPackResources resources;
    @NotNull
    private final InMemoryPackResources.Supplier supplier;
    @NotNull
    private final class_9225 config;
    @Nullable
    private class_3288 base;

    public InMemoryPack(@NotNull class_3264 type, @NotNull class_9224 location, @NotNull class_9225 config) {
        this.type = type;
        this.location = location;
        this.resources = new InMemoryPackResources(type, location);
        this.supplier = new InMemoryPackResources.Supplier(this.resources);
        this.config = config;
    }

    public void create() {
        if (this.base != null) {
            LOGGER.warn("Trying to create a already created In-Memory Pack: {}", (Object)this.resources.method_56926().comp_2329());
        }
        int format = class_155.method_16673().method_70592(this.type);
        class_3288.class_7679 resourcesMetadata = class_3288.method_45274((class_9224)this.resources.method_56926(), (class_3288.class_7680)this.supplier, (int)format);
        class_3288.class_7679 metadata = Objects.requireNonNullElseGet(resourcesMetadata, InMemoryPack::createDefaultMetadata);
        this.base = new class_3288(this.resources.method_56926(), (class_3288.class_7680)this.supplier, metadata, this.config);
    }

    public Optional<InMemoryResource> addResource(@NotNull class_2960 location, byte @NotNull [] buffer) {
        return this.resources.addResource(location, buffer);
    }

    public Optional<InMemoryResource> removeResource(@NotNull class_2960 location) {
        return this.resources.removeResource(location);
    }

    public boolean containsResource(@NotNull class_2960 location) {
        return this.resources.containsResource(location);
    }

    @NotNull
    public class_3264 type() {
        return this.type;
    }

    @NotNull
    public class_9224 location() {
        return this.location;
    }

    @NotNull
    public Optional<class_3288> base() {
        return Optional.ofNullable(this.base);
    }

    @NotNull
    public InMemoryPackResources open() {
        return this.supplier.openFull(this.resources.method_56926(), null);
    }

    private static class_3288.class_7679 createDefaultMetadata() {
        return new class_3288.class_7679((class_2561)class_2561.method_43470((String)"The in-memory pack of Memora"), class_3281.field_14224, null, new ArrayList());
    }
}

